/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.stats;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.service.WorkflowSearchService;
import com.comalatech.confluence.workflowreports.manager.stats.DocumentStatsReportManager;
import com.comalatech.confluence.workflowreports.model.presenter.stats.DocumentStatsReportOptionsCqlPresenter;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReport;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReportOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DefaultDocumentStatsReportManager
implements DocumentStatsReportManager {
    private final CQLSearchService cqlSearchService;
    private final WorkflowSearchService workflowSearchService;

    public DefaultDocumentStatsReportManager(@ComponentImport CQLSearchService cqlSearchService, WorkflowSearchService workflowSearchService) {
        this.cqlSearchService = cqlSearchService;
        this.workflowSearchService = workflowSearchService;
    }

    @Override
    public DocumentStatsReport createReport(DocumentStatsReportOptions statsReportOptions) {
        DocumentStatsReport documentStatsReport = new DocumentStatsReport();
        ArrayList<String> statesNames = !statsReportOptions.getStateNames().isEmpty() ? statsReportOptions.getStateNames() : new ArrayList<String>(this.getStatesNames(statsReportOptions.getSpaceKeys()));
        for (String state : statesNames) {
            statsReportOptions.setStateName(state);
            DocumentStatsReportOptionsCqlPresenter documentStatsReportOptionsCqlPresenter = new DocumentStatsReportOptionsCqlPresenter(statsReportOptions);
            String cqlQuery = (String)documentStatsReportOptionsCqlPresenter.present().get("cqlQuery");
            SearchPageResponse search = this.cqlSearchService.search(cqlQuery, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(0, 0), new Expansion[0]);
            documentStatsReport.addStateCount(state, search.totalSize());
        }
        return documentStatsReport;
    }

    protected Set<String> getStatesNames(List<String> spaceKeys) {
        HashSet<String> stateNames = new HashSet<String>();
        spaceKeys.forEach(space -> stateNames.addAll(this.workflowSearchService.getSpaceStates((String)space)));
        return stateNames;
    }
}

