/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.templates.BaseMacro;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionMacro
extends BaseMacro {
    private static final Logger log = LoggerFactory.getLogger(AbstractActionMacro.class);
    public static final String EXECUTE_KEY = "com.comalatech.execute";
    private static final String IPC = "ipc";
    public static final String LOG_KEY = "com.comalatech.log";
    public static final String ERROR_SEGMENT = "class=\"error\"";
    public static final String USER_MESSAGE_KEY = "com.comalatech.user.message";
    protected static final String PAGE_PARAM = "page";
    protected static final String PAGE_PARAM_PARENT = "@parent";
    protected static final String PAGE_PARAM_CHILDREN = "@children";
    protected ValueStoreManager valueStoreManager;
    protected PageMessageManager pageMessageManager;
    protected ComalaI18nBean comalaI18nBean;
    private static final int MAX_STACK_LINES = 20;
    private static final int MAX_PRECEDING_LINES = 3;
    protected UsersListResolver usersListResolver;

    protected abstract String getName();

    protected ValueStore getValueStore(RenderContext renderContext) throws WorkflowException {
        ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        if (valueStore == null) {
            throw new WorkflowException("Value store not set");
        }
        return valueStore;
    }

    protected boolean inExecuteMode(RenderContext renderContext) {
        return this.inWorkflowAction(renderContext) || renderContext.getParam((Object)IPC) != null;
    }

    protected boolean inWorkflowAction(RenderContext renderContext) {
        return renderContext.getParam((Object)EXECUTE_KEY) != null;
    }

    protected void logMessage(RenderContext renderContext, String type, String message) {
        message = RenderUtils.sanitizeBlock(message);
        StringBuilder sb = new StringBuilder();
        String log = (String)renderContext.getParam((Object)LOG_KEY);
        if (log != null) {
            sb.append(log);
        }
        sb.append("h4. ").append(type).append("\n");
        sb.append(message).append("\n\n");
        renderContext.addParam((Object)LOG_KEY, (Object)sb.toString());
    }

    private void logMessage(RenderContext renderContext, WorkflowException exception) {
        this.logMessage(renderContext, "Workflow error:", exception.getMessage());
    }

    protected void logMessage(RenderContext renderContext, Exception exception) {
        if (log.isDebugEnabled()) {
            log.debug("Error", (Throwable)exception);
        }
        if (exception instanceof WorkflowException) {
            this.logMessage(renderContext, (WorkflowException)exception);
            this.setPageMessage(renderContext, exception.getMessage());
        } else if (exception instanceof IllegalArgumentException) {
            this.logMessage(renderContext, "IllegalArgumentException:", exception.getMessage());
            this.setPageMessage(renderContext, exception.getMessage());
        } else {
            StringBuilder sb = new StringBuilder(exception.getClass().getName() + ": " + exception.getMessage());
            StackTraceElement[] stacktrace = exception.getStackTrace();
            this.appendExceptionLines(stacktrace, sb);
            String message = "{code}\n" + sb + "\n{code}\n";
            this.logMessage(renderContext, "Exception " + (String)(stacktrace.length >= 20 ? "( " + stacktrace.length + " lines)" : ""), message);
        }
    }

    private void setPageMessage(RenderContext renderContext, String message) {
        if (!(renderContext instanceof PageContext)) {
            log.error("invalid render context " + renderContext + " when logging " + message);
        }
        String msg = this.comalaI18nBean.getText("approvalsworkflow.workflow.error", new String[]{RenderUtils.sanitizeBlock(message)});
        this.pageMessageManager.setMessage((AbstractPage)((PageContext)renderContext).getEntity(), null, msg, "error", 60L);
    }

    private void appendExceptionLines(StackTraceElement[] stacktrace, StringBuilder sb) {
        int i;
        int lines = 0;
        int start = 0;
        for (i = 0; i < stacktrace.length; ++i) {
            StackTraceElement stackTraceElement = stacktrace[i];
            if (!stackTraceElement.getClassName().contains("comalatech")) continue;
            start = i > 3 ? i - 3 : 0;
            break;
        }
        for (i = start; i < stacktrace.length && lines < 20; ++lines, ++i) {
            StackTraceElement element = stacktrace[i];
            sb.append("\n at ").append(element.toString());
        }
    }

    protected List<AbstractPage> getPagesFromParams(Map parameters, RenderContext renderContext) throws MacroException {
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        String pageParam = MapUtils.getString(parameters, PAGE_PARAM);
        if (StringUtils.isNotBlank((CharSequence)pageParam)) {
            if (pageParam.equals(PAGE_PARAM_PARENT)) {
                Page parentPage = this.getPage(renderContext).getParent();
                if (parentPage != null) {
                    pages.add((AbstractPage)parentPage);
                }
            } else if (pageParam.equals(PAGE_PARAM_CHILDREN)) {
                pages.addAll(this.getPage(renderContext).getChildren());
            }
        } else {
            pages.add(this.getAbstractPage(renderContext));
        }
        return pages;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public static boolean hasError(String wiki) {
        return wiki.contains(ERROR_SEGMENT);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public void setValueStoreManager(ValueStoreManager valueStoreManager) {
        this.valueStoreManager = valueStoreManager;
    }

    public void setUsersListResolver(UsersListResolver usersListResolver) {
        this.usersListResolver = usersListResolver;
    }

    public void setPageMessageManager(PageMessageManager pageMessageManager) {
        this.pageMessageManager = pageMessageManager;
    }

    public void setComalaI18nBean(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }
}

