/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.RestCommand;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestWorkflowCommand
extends RestCommand {
    private static final Logger log = LoggerFactory.getLogger(RestWorkflowCommand.class);
    private final WorkflowPermissionManager workflowPermissionManager;
    private final SpaceManager spaceManager;
    private List<String> spacekeys;

    protected RestWorkflowCommand(WorkflowsFeatureManager workflowsFeatureManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager) {
        super(workflowsFeatureManager, permissionManager);
        this.workflowPermissionManager = workflowPermissionManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public abstract Response doExecute() throws WorkflowException;

    public Response execute(List<String> spacekeys) {
        this.spacekeys = spacekeys;
        return super.execute();
    }

    @Override
    protected RestWorkflowCommand validate() throws ApplicationPermissionException {
        Method enclosingMethod = this.getClass().getEnclosingMethod();
        if (enclosingMethod == null) {
            throw new RuntimeException("command must be anonymous class");
        }
        super.validate();
        this.validateWorkflowsVisibilityPermissions();
        return this;
    }

    private void validateWorkflowsVisibilityPermissions() throws ApplicationPermissionException {
        if (this.spacekeys != null) {
            Method method = this.getClass().getEnclosingMethod();
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            for (String spacekey : this.spacekeys) {
                if (null == method.getAnnotation(WorkflowVisibilityPermissionsRequired.class) && null == method.getAnnotation(ViewWorkflowPermissionRequired.class) || this.workflowPermissionManager.canViewWorkflows(this.spaceManager.getSpace(spacekey), user)) continue;
                throw new ApplicationPermissionException("Forbidden: The user has no view/edit permissions on the space " + spacekey + " and the Workflows visibility configuration setting does not allow to override that restriction.");
            }
        }
    }
}

