/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.tasks;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;

public class SpaceUpgradeRevertTask
extends ConfluenceAbstractLongRunningTask {
    private final Space space;
    private final UpgradeTask revertTask;
    private final PageManager pageManager;
    private final DocumentActivityService documentActivityService;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final ComalaI18nBean comalaI18nBean;

    public SpaceUpgradeRevertTask(Space space, UpgradeTask revertTask, @ComponentImport PageManager pageManager, DocumentActivityService documentActivityService, DocumentActivityUpgradeService documentActivityUpgradeService, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, ReadWriteTransactionService readWriteTransactionService, ComalaI18nBean comalaI18nBean) {
        this.space = space;
        this.revertTask = revertTask;
        this.pageManager = pageManager;
        this.documentActivityService = documentActivityService;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.readWriteTransactionService = readWriteTransactionService;
        this.comalaI18nBean = comalaI18nBean;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        try {
            if (this.isRevertTaskReadyToStart()) {
                log.debug("Upgrade Revert task started for space " + this.space.getKey());
                Collection pageIds = this.pageManager.getPageIds(this.space);
                if (pageIds.isEmpty()) {
                    log.debug("No pages found for space " + this.space.getKey());
                    this.revertTask.setStatus(Status.NOT_RUN);
                    return;
                }
                this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                    this.documentActivityService.deleteBySpace(this.space.getId());
                    pageIds.forEach(pageId -> {
                        this.stateAccessor.removeLatestFinalState((AbstractPage)this.pageManager.getPage(pageId.longValue()));
                        this.approvalAccessor.removeApprovalChecksBeforeLastFinalState((AbstractPage)this.pageManager.getPage(pageId.longValue()));
                    });
                    return null;
                });
                this.revertTask.setStatus(Status.NOT_RUN);
            } else {
                log.error("Error starting the long running task for the space " + this.space.getKey());
                this.revertTask.setStatus(Status.REVERT_FAIL);
            }
        }
        catch (Exception e) {
            log.error("Failed to revert the space upgrade for space " + this.space.getKey(), (Throwable)e);
            this.revertTask.setStatus(Status.REVERT_FAIL);
            this.revertTask.setDuration(TimerUtils.getDuration(startedAt));
            this.progress.setCompletedSuccessfully(false);
        }
        if (Status.REVERT_FAIL.equals((Object)this.revertTask.getStatus())) {
            this.progress.setCompletedSuccessfully(false);
        } else if (Status.NOT_RUN.equals((Object)this.revertTask.getStatus())) {
            this.progress.setCompletedSuccessfully(true);
        }
        this.revertTask.setDuration(TimerUtils.getDuration(startedAt));
        this.documentActivityUpgradeService.saveSpaceUpgrade(this.space, this.revertTask);
        this.progress.setPercentage(100);
        log.debug("Upgrade Revert task finished for space " + this.space.getKey());
    }

    private boolean isRevertTaskReadyToStart() throws InterruptedException {
        UpgradeTask revertTaskStored = this.documentActivityUpgradeService.getSpaceUpgrade(this.space);
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(180L);
        while (!Status.REVERT_IN_PROGRESS.equals((Object)revertTaskStored.getStatus()) && TimerUtils.toEpochMilli(LocalDateTime.now()) <= TimerUtils.toEpochMilli(timeLimit)) {
            revertTaskStored = this.documentActivityUpgradeService.getSpaceUpgrade(this.space);
            Thread.sleep(2000L);
        }
        this.revertTask.setStartedAt(revertTaskStored.getStartedAt());
        return Status.REVERT_IN_PROGRESS.equals((Object)revertTaskStored.getStatus());
    }

    public String getName() {
        return this.comalaI18nBean.getText("comalatech.awp.global.workflows.upgrade.revert.task");
    }
}

