/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUnassignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUnassignEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;
import org.apache.commons.lang3.StringUtils;

public class TaskUnassignmentMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskUnassignmentMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskUnassignEvent) {
            PageTaskUnassignEvent pageTaskUnassignEvent = (PageTaskUnassignEvent)event;
            return this.buildActivity((AbstractPage)pageTaskUnassignEvent.getPage(), (PageState)pageTaskUnassignEvent.getState(), (PageTask)pageTaskUnassignEvent.getTask(), pageTaskUnassignEvent.getAssignment());
        }
        if (event instanceof BlogPostTaskUnassignEvent) {
            BlogPostTaskUnassignEvent blogPostTaskUnassignEvent = (BlogPostTaskUnassignEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskUnassignEvent.getBlogPost(), (PageState)blogPostTaskUnassignEvent.getState(), (PageTask)blogPostTaskUnassignEvent.getTask(), blogPostTaskUnassignEvent.getAssignment());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, Assignment assignment) throws WorkflowUserException {
        Target target = TaskUnassignmentMapper.buildTarget((ContentEntityObject)abstractPage);
        ActionType task = new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_UNASSIGNMENT);
        Actor actor = this.actorUtils.buildActor(assignment.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.TASK_NAME, pageTask.getName());
        String comment = assignment.getComment();
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetailType.TASK_COMMENT, comment);
        }
        Actor unassignedUser = this.actorUtils.buildActor(pageTask.getUnassignedUser());
        details.addDetail(ActionDetailType.TASK_USER_UNASSIGNED, unassignedUser.getId());
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(task, actor, details);
        return new Activity(target, assignment.getDate().getTime(), action);
    }
}

