/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.listener;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.PaginatedContainers;
import com.atlassian.migration.app.disco.MultiTransferDiscoverableListener;
import com.atlassian.migration.app.disco.TransferDefinition;
import com.atlassian.migration.app.disco.TransferInfo;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.usecases.CsvActivityMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.CurrentStateMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.GlobalWorkflowMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.contracts.SpaceMigrationProcessor;
import com.comalatech.confluence.license.ComalaDocumentAppManager;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowsCloudMigrationListener
implements MultiTransferDiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsCloudMigrationListener.class);
    public static final String GLOBAL_WORKFLOWS_TRANSFER_NAME = "Global Workflow Definitions";
    public static final String CURRENT_STATE_AND_CUSTOM_WORKFLOWS_TRANSFER_NAME = "Space Workflows & Current Page State";
    public static final String DOCUMENT_ACTIVITY_TRANSFER_NAME = "Document Activity";
    private final PluginLicenseManager licenseManager;
    private final Presenter<File> fileJsonPresenter;
    private final Presenter<String> jsonPresenter;
    private final SpaceMigrationProcessor spaceMigrationProcessor;
    private final CurrentStateMigrationProcessor currentStateMigrationProcessor;
    private final CsvActivityMigrationProcessor csvActivityMigrationProcessor;
    private final GlobalWorkflowMigrationProcessor globalWorkflowMigrationProcessor;
    private final ObjectMapper objectMapper;
    private final ComalaDocumentAppManager comalaDocumentAppManager;
    private final WorkflowService workflowService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private static final int SPACE_CONTAINERS_BATCH = 50;

    public WorkflowsCloudMigrationListener(@ComponentImport PluginLicenseManager pluginLicenseManager, @Qualifier(value="fileJsonPresenter") Presenter<File> fileJsonPresenter, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, ComalaDocumentAppManager comalaDocumentAppManager, SpaceMigrationProcessor spaceMigrationProcessor, CurrentStateMigrationProcessor currentStateMigrationProcessor, CsvActivityMigrationProcessor csvActivityMigrationProcessor, GlobalWorkflowMigrationProcessor globalWorkflowMigrationProcessor, WorkflowService workflowService, ReadWriteTransactionService readWriteTransactionService, GeneratePageActivityMigrationData pageActivityGeneratorUseCase) {
        this.licenseManager = pluginLicenseManager;
        this.fileJsonPresenter = fileJsonPresenter;
        this.spaceMigrationProcessor = spaceMigrationProcessor;
        this.currentStateMigrationProcessor = currentStateMigrationProcessor;
        this.csvActivityMigrationProcessor = csvActivityMigrationProcessor;
        this.jsonPresenter = jsonPresenter;
        this.comalaDocumentAppManager = comalaDocumentAppManager;
        this.globalWorkflowMigrationProcessor = globalWorkflowMigrationProcessor;
        this.workflowService = workflowService;
        this.readWriteTransactionService = readWriteTransactionService;
        this.pageActivityGeneratorUseCase = pageActivityGeneratorUseCase;
        this.objectMapper = new ObjectMapper();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails) {
        try {
            log.warn("Migration context summary: {}. Migration process could take a while processing the spaces.", (Object)this.objectMapper.writeValueAsString(migrationDetails));
            PaginatedContainers paginatedSiteContainers = gateway.getPaginatedContainers(transferInfo.getTransferId().toString(), ContainerType.ConfluenceSpace, 50);
            LinkedHashSet<String> spaceKeyList = new LinkedHashSet<String>();
            while (paginatedSiteContainers.next()) {
                spaceKeyList.addAll(WorkflowsCloudMigrationListener.getSpaceKeys(paginatedSiteContainers));
            }
            List spacesWithWorkflows = this.readWriteTransactionService.executeInReadWriteTransaction(() -> this.workflowService.getSpacesWithWorkflows(spaceKeyList));
            ArrayList<Migration> migrations = new ArrayList<Migration>();
            switch (transferInfo.getTransferName()) {
                case "Global Workflow Definitions": {
                    migrations.add(this.processGlobalWorkflowsMigration(gateway, transferInfo.getTransferId().toString()));
                    break;
                }
                case "Document Activity": {
                    migrations.add(this.processDocumentActivityMigration(gateway, transferInfo, migrationDetails, spacesWithWorkflows));
                    break;
                }
                case "Space Workflows & Current Page State": {
                    migrations.add(this.processSpaceWorkflowsMigration(gateway, transferInfo.getTransferId().toString(), spacesWithWorkflows));
                    migrations.add(this.processCurrentStateMigration(gateway, transferInfo, migrationDetails, spacesWithWorkflows));
                }
            }
            for (Migration migration : migrations) {
                File jsonFile = this.fileJsonPresenter.present(migration);
                try {
                    log.info("Sending {} bytes of data for transferId {} and label {} ", new Object[]{jsonFile.length(), transferInfo.getTransferId().toString(), migration.label});
                    this.sendActivitiesToMigrationService(gateway, transferInfo, jsonFile, migration.label + "-" + this.comalaDocumentAppManager.getVersionNumber());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error("Error during the migration process", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Migration processSpaceWorkflowsMigration(AppCloudMigrationGateway gateway, String transferId, List<String> spacesWithWorkflows) throws Exception {
        return this.spaceMigrationProcessor.process(gateway, spacesWithWorkflows, transferId);
    }

    private Migration processDocumentActivityMigration(AppCloudMigrationGateway gateway, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails, List<String> spacesWithWorkflows) throws Exception {
        return this.csvActivityMigrationProcessor.process(gateway, this.pageActivityGeneratorUseCase.getActivities(spacesWithWorkflows), transferInfo, migrationDetails);
    }

    private Migration processCurrentStateMigration(AppCloudMigrationGateway gateway, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails, List<String> spacesWithWorkflows) throws Exception {
        return this.currentStateMigrationProcessor.process(gateway, this.pageActivityGeneratorUseCase.getActivities(spacesWithWorkflows), transferInfo, migrationDetails);
    }

    private Migration processGlobalWorkflowsMigration(AppCloudMigrationGateway gateway, String transferId) throws Exception {
        return this.globalWorkflowMigrationProcessor.process(gateway, transferId);
    }

    @Override
    public Set<TransferDefinition> getTransferDefinitions() {
        HashSet<TransferDefinition> transferDefinitions = new HashSet<TransferDefinition>();
        transferDefinitions.add(new TransferDefinition(CURRENT_STATE_AND_CUSTOM_WORKFLOWS_TRANSFER_NAME, false, Set.of(GLOBAL_WORKFLOWS_TRANSFER_NAME)));
        transferDefinitions.add(new TransferDefinition(DOCUMENT_ACTIVITY_TRANSFER_NAME, false, new HashSet<String>()));
        transferDefinitions.add(new TransferDefinition(GLOBAL_WORKFLOWS_TRANSFER_NAME, false, new HashSet<String>()));
        return transferDefinitions;
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }

    private static List<String> getSpaceKeys(PaginatedContainers paginatedSiteContainers) {
        return paginatedSiteContainers.getContainers().stream().filter(ConfluenceSpaceContainerV1.class::isInstance).map(container -> ((ConfluenceSpaceContainerV1)container).getKey()).collect(Collectors.toList());
    }

    private void sendActivitiesToMigrationService(AppCloudMigrationGateway gateway, TransferInfo transferInfo, File jsonActivities, String label) throws IOException {
        try (OutputStream atlassianMigrationDataStream = gateway.createAppData(transferInfo.getTransferId().toString(), label);
             InputStream activitiesDataStream = Files.newInputStream(jsonActivities.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)activitiesDataStream, (OutputStream)atlassianMigrationDataStream);
        }
    }
}

