/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.WorkflowMarkups;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.globalworkflow.GlobalWorkflowMarkups;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.CloudMarkup;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.WorkflowMigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.WorkflowMigrationHelper;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GlobalMigrationProcessor;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="globalWorkflowMigrationProcessor")
public class GlobalWorkflowMigrationProcessor
extends WorkflowMigrationHelper
implements GlobalMigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(GlobalWorkflowMigrationProcessor.class);
    private static final String GLOBAL_WORKFLOW_MIGRATION_VERSION = "1";
    private final SystemInformationService systemInformationService;
    private final WorkflowContainerManager workflowContainerManager;

    public GlobalWorkflowMigrationProcessor(@ComponentImport SystemInformationService systemInformationService, WorkflowContainerManager workflowContainerManager, WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator, @ComponentImport UserAccessor userAccessor, CloudMappingsData cloudMappingsData, @Qualifier(value="cloudWorkflowUserIdPopulationUseCase") CloudPopulationData<String> userPopulationData, @Qualifier(value="cloudWorkflowGroupIdPopulationUseCase") CloudPopulationData<String> groupPopulationData) {
        super(userAccessor, cloudMappingsData, workflowMarkupManager, workflowTranslator, userPopulationData, groupPopulationData);
        this.systemInformationService = systemInformationService;
        this.workflowContainerManager = workflowContainerManager;
    }

    @Override
    public Migration process(AppCloudMigrationGateway gateway, String transferId) throws Exception {
        this.setExecutionDetails(gateway, transferId, WorkflowMigrationHelper.ProcessMode.MIGRATION);
        List<Workflow> workflowList = this.workflowContainerManager.getWorkflowTemplates(null);
        return this._process(workflowList);
    }

    @Override
    public Migration debug() throws Exception {
        this.setExecutionDetails(null, null, WorkflowMigrationHelper.ProcessMode.DEBUG);
        List<Workflow> workflowList = this.workflowContainerManager.getWorkflowTemplates(null);
        return this._process(workflowList);
    }

    private Migration _process(List<Workflow> workflowList) {
        Migration cloudMigration = new Migration();
        WorkflowMigrationEntity migrationEntity = new WorkflowMigrationEntity();
        migrationEntity.setWorkflows(new ArrayList<WorkflowMarkups>());
        workflowList.forEach(workflow -> migrationEntity.getWorkflows().add(this.generateGlobalWorkflowMarkups((Workflow)workflow, this.getUpdatedMarkup((com.comalatech.workflow.model.Workflow)workflow))));
        cloudMigration.migrationEntities.add(migrationEntity);
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = GLOBAL_WORKFLOW_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.GLOBAL_WORKFLOW.getLabel();
        return cloudMigration;
    }

    private WorkflowMarkups generateGlobalWorkflowMarkups(Workflow workflow, String cloudMarkup) {
        return ((GlobalWorkflowMarkups.GlobalWorkflowMarkupsBuilder)((GlobalWorkflowMarkups.GlobalWorkflowMarkupsBuilder)((GlobalWorkflowMarkups.GlobalWorkflowMarkupsBuilder)GlobalWorkflowMarkups.builder().cloudMarkup(CloudMarkup.builder().workflow(cloudMarkup).build())).serverMarkup(workflow.getWorkflowMarkup())).visible(workflow.isActive())).build();
    }
}

