/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ContentMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GlobalMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.SpaceMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationStateMixin;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class MigrationDebugAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(MigrationDebugAction.class);
    private ContentMigrationProcessor pageActivityMigrationProcessor;
    private ContentMigrationProcessor csvActivityMigrationProcessor;
    private SpaceMigrationProcessor spaceWorkflowMigrationProcessor;
    private GlobalMigrationProcessor globalWorkflowMigrationProcessor;
    private AdhocWorkflowsLicenseManager licenseManager;
    private PageManager pageManager;
    private WorkflowService workflowService;
    private String migrationStr;
    private String csvResult;
    private String spaceWorkflow;
    private String globalWorkflow;
    private String spaceKey;
    private Long pageId;

    public String execute() {
        String csvResult;
        String globalWorkflowResult;
        String spaceResult;
        String result;
        if (!this.licenseManager.isLicensed()) {
            this.migrationStr = "Invalid license";
            this.spaceWorkflow = "Invalid license";
            return "success";
        }
        try {
            Migration pageActivityMigration = null;
            Migration spaceWorkflowMigration = null;
            Migration csvActivityMigration = null;
            Migration globalWorkflowMigration = null;
            ObjectMapper mapper = new ObjectMapper();
            if (this.pageId != null) {
                AbstractPage abstractPage = this.pageManager.getAbstractPage(this.pageId.longValue());
                if (abstractPage == null) {
                    this.migrationStr = "Page id does not exist";
                    return "success";
                }
                pageActivityMigration = this.pageActivityMigrationProcessor.debug(abstractPage);
                spaceWorkflowMigration = this.spaceWorkflowMigrationProcessor.debug(abstractPage);
                csvActivityMigration = this.csvActivityMigrationProcessor.debug(abstractPage);
                globalWorkflowMigration = this.globalWorkflowMigrationProcessor.debug();
            } else if (this.spaceKey != null) {
                List<String> spacesWithWorkflow = this.workflowService.getSpacesWithWorkflows(Set.of(this.spaceKey));
                pageActivityMigration = this.pageActivityMigrationProcessor.debug(spacesWithWorkflow);
                spaceWorkflowMigration = this.spaceWorkflowMigrationProcessor.debug(spacesWithWorkflow);
                globalWorkflowMigration = this.globalWorkflowMigrationProcessor.debug();
            }
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.addMixIn(State.class, MigrationStateMixin.class);
            result = mapper.writeValueAsString(pageActivityMigration);
            spaceResult = mapper.writeValueAsString(spaceWorkflowMigration);
            globalWorkflowResult = mapper.writeValueAsString(globalWorkflowMigration);
            csvResult = mapper.writeValueAsString(csvActivityMigration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.migrationStr = result;
        this.spaceWorkflow = spaceResult;
        this.csvResult = csvResult;
        this.globalWorkflow = globalWorkflowResult;
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @ParameterSafe
    public void setMigrationStr(String migrationStr) {
        this.migrationStr = migrationStr;
    }

    @ParameterSafe
    public void setSpaceWorkflow(String spaceWorkflow) {
        this.spaceWorkflow = spaceWorkflow;
    }

    @ParameterSafe
    public void setGlobalWorkflow(String globalWorkflow) {
        this.globalWorkflow = globalWorkflow;
    }

    @ParameterSafe
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @ParameterSafe
    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public void setPageActivityMigrationProcessor(@Qualifier(value="pageActivityMigrationProcessor") ContentMigrationProcessor pageActivityMigrationProcessor) {
        this.pageActivityMigrationProcessor = pageActivityMigrationProcessor;
    }

    public void setCsvActivityMigrationProcessor(@Qualifier(value="csvActivityMigrationProcessor") ContentMigrationProcessor csvActivityMigrationProcessor) {
        this.csvActivityMigrationProcessor = csvActivityMigrationProcessor;
    }

    public void setSpaceWorkflowMigrationProcessor(@Qualifier(value="spaceWorkflowMigrationProcessor") SpaceMigrationProcessor spaceWorkflowMigrationProcessor) {
        this.spaceWorkflowMigrationProcessor = spaceWorkflowMigrationProcessor;
    }

    public void setGlobalWorkflowMigrationProcessor(@Qualifier(value="globalWorkflowMigrationProcessor") GlobalMigrationProcessor globalWorkflowMigrationProcessor) {
        this.globalWorkflowMigrationProcessor = globalWorkflowMigrationProcessor;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public String getMigrationStr() {
        return this.migrationStr;
    }

    public String getCsvResult() {
        return this.csvResult;
    }

    public String getSpaceWorkflow() {
        return this.spaceWorkflow;
    }

    public String getGlobalWorkflow() {
        return this.globalWorkflow;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Long getPageId() {
        return this.pageId;
    }
}

