/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceHasBrikitTheme
extends BaseConfluenceCondition {
    private static final Logger log = LoggerFactory.getLogger(SpaceHasBrikitTheme.class);
    private static final String BRIKIT_KEY = "com.brikit.themepress:theme-base";
    private final ThemeManager themeManager;

    public SpaceHasBrikitTheme(@ComponentImport ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext context) {
        try {
            Space space = context.getSpace();
            Theme spaceTheme = this.themeManager.getSpaceTheme(space.getKey());
            return BRIKIT_KEY.equals(spaceTheme.getPluginKey() + ":" + spaceTheme.getModuleKey());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while checking space theme", (Throwable)e);
            }
            return false;
        }
    }
}

