/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cw', 'jquery', 'underscore'], function(CW, $, _) {
    // Infinite scroll load handling
    function infiniteScroll(iframeView) {
        function sendLoadMore(edge, limit) {
            if (edge <= limit) {
                iframeView.send('loadMore');
            }
        }

        var loadMore = _.throttle(sendLoadMore, 600);

        function onScroll() {
            // get current scroll view limit
            var position = $(window).scrollTop();
            var windowHeight = $(window).height();
            // get iframe's bottom position
            var iframeOffset = iframeView.$el.offset();
            var iframeHeight = iframeView.$el.height();
            var iframeEdge = iframeHeight + iframeOffset.top;
            // send a loadMore event whenever the iframe bottom is about half the screen height away
            var bottomLimit = position + windowHeight + (windowHeight / 2);
            loadMore(iframeEdge, bottomLimit);
        }

        return onScroll;
    }

    CW.toInit(function () {
        // Document Activity Setup
        var DocumentActivityIframe = new CW.iframe({
            id: 'DocumentActivityIframe',
            url: '/documentactivity/' + CW.getParam('pageId'),
            width: '100%',
            height: '100%',
            customData: {
                dateFormat: CW.getParam('cwConfluenceDateFormat'),
                timeFormat: CW.getParam('cwConfluenceTimeFormat'),
                dateTimeFormat: CW.getParam('cwConfluenceDateTimeFormat'),
                locale: CW.getParam('cwConfluenceLocale'),
                timeZone: CW.getParam('cwTimeZone'),
            },
            query: {
                showInlineComments: CW.getDarkFeature('comalatech.workflows.show.page.inline-comments'),
                oracledbOldActivity: CW.getDarkFeature('comalatech.workflows.oracledb.oldactivity.enabled')
            }
        });

        $('#cw-document-activity-container').html(DocumentActivityIframe.render());
        
        $(window).on('scroll', infiniteScroll(DocumentActivityIframe));
        $(window).on('click', function() {
            DocumentActivityIframe.send('clickOutside');
        });
    });
});
