/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.randombits.storage.AbstractStorage;
import org.randombits.storage.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasedStorage
extends AbstractStorage {
    private Map<String, Object> box;
    private Stack<Map<String, Object>> boxes;
    private String topBoxName;
    private BoxType boxType;

    public BasedStorage(BoxType boxType) {
        this.boxType = boxType;
    }

    protected abstract Set<String> baseNameSet();

    @Override
    public void openBox(String name) {
        super.openBox(name);
        if (this.boxType == BoxType.Real) {
            Map<String, Object> newBox = this.getObject(name, null, Map.class);
            if (newBox == null) {
                newBox = this.createBox();
            }
            if (this.box != null) {
                if (this.boxes == null) {
                    this.boxes = new Stack();
                }
                this.box.put(name, newBox);
                this.boxes.push(this.box);
            }
            this.box = newBox;
        }
        if (this.topBoxName == null) {
            this.topBoxName = name;
        }
    }

    protected Map<String, Object> createBox() {
        return new HashMap<String, Object>();
    }

    @Override
    public void closeBox() {
        super.closeBox();
        if (this.boxType == BoxType.Real) {
            if (this.boxes != null && this.boxes.size() != 0) {
                this.box = this.boxes.pop();
            } else {
                if (!this.isReadOnly()) {
                    this.setBaseObject(this.topBoxName, this.box);
                }
                this.box = null;
                this.topBoxName = null;
            }
        }
    }

    protected abstract Boolean getBaseBoolean(String var1);

    protected abstract Date getBaseDate(String var1);

    protected abstract Double getBaseDouble(String var1);

    protected abstract Integer getBaseInteger(String var1);

    protected abstract Long getBaseLong(String var1);

    protected abstract Number getBaseNumber(String var1);

    protected abstract Object getBaseObject(String var1);

    protected abstract List<?> getBaseObjectList(String var1);

    protected abstract String getBaseString(String var1);

    protected abstract String[] getBaseStringArray(String var1) throws StorageException;

    protected <T> T getBoxValue(String name, Class<T> clazz) {
        Object value = this.box.get(name);
        return this.toType(value, null, clazz);
    }

    @Override
    public Boolean getBoolean(String name, Boolean def) {
        try {
            Boolean value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseBoolean(name) : this.getBoxValue(name, Boolean.class)) : this.getBaseBoolean(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Date getDate(String name, Date def) {
        try {
            Date value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseDate(name) : this.getBoxValue(name, Date.class)) : this.getBaseDate(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Double getDouble(String name, Double def) {
        try {
            Number number;
            Double value = this.boxType == BoxType.Real ? (this.box != null ? ((number = this.getBoxValue(name, Number.class)) != null ? new Double(number.doubleValue()) : null) : this.getBaseDouble(name)) : this.getBaseDouble(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Integer getInteger(String name, Integer def) {
        try {
            Number number;
            Integer value = this.boxType == BoxType.Real ? (this.box != null ? ((number = this.getBoxValue(name, Number.class)) != null ? new Integer(number.intValue()) : null) : this.getBaseInteger(name)) : this.getBaseInteger(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Long getLong(String name, Long def) {
        try {
            Number number;
            Long value = this.boxType == BoxType.Real ? (this.box != null ? ((number = this.getBoxValue(name, Number.class)) != null ? new Long(number.longValue()) : null) : this.getBaseLong(name)) : this.getBaseLong(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Number getNumber(String name, Number def) {
        try {
            Number value = this.boxType == BoxType.Real ? (Number)(this.box != null ? (Number)this.getBoxValue(name, Number.class) : (Number)this.getBaseNumber(name)) : (Number)this.getBaseNumber(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public <T> T getObject(String name, T def, Class<T> type) {
        Object value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseObject(name) : this.box.get(name)) : this.getBaseObject(this.makePath(name));
        return this.toType(value, def, type);
    }

    protected <T> T toType(Object value, T def, Class<T> type) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        return def;
    }

    @Override
    public List<?> getObjectList(String name, List<?> def) {
        List<Object> value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseObjectList(name) : this.getBoxValue(name, List.class)) : this.getBaseObjectList(this.makePath(name));
        if (value == null) {
            return def;
        }
        return value;
    }

    @Override
    public String getString(String name, String def) {
        try {
            String value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseString(name) : this.getBoxValue(name, String.class)) : this.getBaseString(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public String[] getStringArray(String name, String[] def) {
        try {
            String[] value = this.boxType == BoxType.Real ? (this.box == null ? this.getBaseStringArray(name) : this.getBoxValue(name, String[].class)) : this.getBaseStringArray(this.makePath(name));
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (ClassCastException e) {
            throw new StorageException(this.makePath(name), e);
        }
    }

    @Override
    public Set<String> nameSet() {
        if (this.box == null) {
            return this.baseNameSet();
        }
        return this.box.keySet();
    }

    protected abstract void setBaseBoolean(String var1, Boolean var2);

    protected abstract void setBaseDate(String var1, Date var2);

    protected abstract void setBaseDouble(String var1, Double var2);

    protected abstract void setBaseInteger(String var1, Integer var2);

    protected abstract void setBaseLong(String var1, Long var2);

    protected abstract void setBaseObject(String var1, Object var2);

    protected abstract void setBaseObjectList(String var1, List<?> var2);

    protected abstract void setBaseString(String var1, String var2);

    protected abstract void setBaseStringArray(String var1, String[] var2);

    @Override
    public void setBoolean(String name, Boolean value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseBoolean(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseBoolean(this.makePath(name), value);
        }
    }

    @Override
    public void setDate(String name, Date value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseDate(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseDate(this.makePath(name), value);
        }
    }

    @Override
    public void setDouble(String name, Double value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseDouble(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseDouble(this.makePath(name), value);
        }
    }

    @Override
    public void setInteger(String name, Integer value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseInteger(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseInteger(this.makePath(name), value);
        }
    }

    @Override
    public void setLong(String name, Long value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseLong(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseLong(this.makePath(name), value);
        }
    }

    @Override
    public void setObject(String name, Object value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseObject(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseObject(this.makePath(name), value);
        }
    }

    @Override
    public void setObjectList(String name, List<?> value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseObjectList(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseObjectList(this.makePath(name), value);
        }
    }

    @Override
    public void setString(String name, String value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseString(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseString(this.makePath(name), value);
        }
    }

    @Override
    public void setStringArray(String name, String[] value) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            if (this.box == null) {
                this.setBaseStringArray(name, value);
            } else {
                this.box.put(name, value);
            }
        } else {
            this.setBaseStringArray(this.makePath(name), value);
        }
    }

    @Override
    public boolean removeBox(String name) {
        this.checkReadOnly();
        if (this.boxType == BoxType.Real) {
            Map box = (Map)this.getBaseObject(name);
            if (box != null) {
                this.setBaseObject(name, null);
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoxType {
        Real,
        Virtual;

    }
}

