/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria;

import java.util.BitSet;
import org.randombits.confluence.filtering.criteria.AndCriteria;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.NotCriterion;
import org.randombits.confluence.filtering.criteria.OrCriteria;
import org.randombits.util.TextBuffer;
import org.randombits.util.TokenIterator;

public class CriteriaParser {
    private static final char OPEN_PAREN_CHAR = '(';
    private static final char CLOSE_PAREN_CHAR = ')';
    private static final char REQ_CHAR = '+';
    private static final char EXCLUDED_CHAR = '-';
    private static final char QUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char COMMA_CHAR = ',';
    private static final char SEMICOLON_CHAR = ';';
    private static final BitSet WHITESPACE = new BitSet();
    private static final BitSet SEPARATOR = new BitSet();
    private static final BitSet RESERVED = new BitSet();
    private static final BitSet UNQUOTED = new BitSet();
    private static final BitSet QUOTED = new BitSet();
    private BitSet separator = new BitSet();
    private BitSet unquoted;

    public CriteriaParser() {
        this(false);
    }

    public CriteriaParser(boolean whitespaceSeparator) {
        this.separator.or(SEPARATOR);
        this.unquoted = new BitSet();
        this.unquoted.or(UNQUOTED);
        if (whitespaceSeparator) {
            this.separator.or(WHITESPACE);
            this.unquoted.andNot(WHITESPACE);
        }
    }

    public Criterion parse(String filterValue, CriterionInterpreter criterionInterpreter) throws CriteriaException {
        TokenIterator i = new TokenIterator(filterValue.trim());
        Criterion criterion = this.parseList(i, criterionInterpreter);
        if (!i.atEnd()) {
            throw new CriteriaException("Unexpected values at end: '" + i.getSequence(TokenIterator.ALL_CHARS) + "'");
        }
        return criterion;
    }

    private Criterion parseList(TokenIterator i, CriterionInterpreter criterionInterpreter) throws CriteriaException {
        OrCriteria optCriteria = new OrCriteria(new Criterion[0]);
        AndCriteria reqCriteria = new AndCriteria(new Criterion[0]);
        AndCriteria excludedCriteria = new AndCriteria(new Criterion[0]);
        boolean continuing = true;
        while (continuing && !i.atEnd()) {
            this.parseListItem(i, criterionInterpreter, optCriteria, reqCriteria, excludedCriteria);
            continuing = i.getSequence(this.separator, 1) != null;
        }
        if (excludedCriteria.getCriteria().size() > 0) {
            AndCriteria criteria = new AndCriteria(new Criterion[0]);
            criteria.addCriterion(excludedCriteria);
            if (reqCriteria.getCriteria().size() > 0) {
                criteria.addCriterion(reqCriteria);
            } else if (optCriteria.getCriteria().size() > 0) {
                criteria.addCriterion(optCriteria);
            } else {
                return excludedCriteria;
            }
            return criteria;
        }
        if (reqCriteria.getCriteria().size() > 0) {
            return reqCriteria;
        }
        return optCriteria;
    }

    private void parseListItem(TokenIterator i, CriterionInterpreter criterionInterpreter, Criteria optCriteria, Criteria reqCriteria, Criteria excludedCriteria) throws CriteriaException {
        i.getSequence(WHITESPACE);
        if (i.getToken(43) != null) {
            reqCriteria.addCriterion(this.parseCriterion(i, criterionInterpreter));
        } else if (i.getToken(45) != null) {
            excludedCriteria.addCriterion(new NotCriterion(this.parseCriterion(i, criterionInterpreter)));
        } else {
            optCriteria.addCriterion(this.parseCriterion(i, criterionInterpreter));
        }
    }

    private Criterion parseGroup(TokenIterator i, CriterionInterpreter criterionInterpreter) throws CriteriaException {
        i.getToken(40);
        Criterion group = this.parseList(i, criterionInterpreter);
        if (i.getToken(41) == null) {
            throw new CriteriaException("Expected ')'");
        }
        return group;
    }

    private Criterion parseCriterion(TokenIterator i, CriterionInterpreter criterionInterpreter) throws CriteriaException {
        if (i.matchToken(40)) {
            return this.parseGroup(i, criterionInterpreter);
        }
        TextBuffer buff = new TextBuffer();
        boolean done = false;
        while (!done) {
            if (i.getToken(34) != null) {
                this.readQuotedCriterion(i, buff);
                continue;
            }
            CharSequence value = i.getSequence(this.unquoted, 1);
            if (value != null) {
                buff.add(value);
                continue;
            }
            done = true;
        }
        return criterionInterpreter.createCriterion(buff.toString());
    }

    private void readQuotedCriterion(TokenIterator i, TextBuffer buff) throws CriteriaException {
        while (!i.atEnd() && !i.matchToken(34)) {
            buff.add(i.getSequence(QUOTED));
            if (i.getToken(92) == null) continue;
            CharSequence escaped = i.getSequence(TokenIterator.ALL_CHARS, 1, 1);
            if (escaped == null) {
                throw new CriteriaException("Expected a character to escape after '\\'");
            }
            buff.add(escaped);
        }
        if (i.getToken(34) == null) {
            throw new CriteriaException("Expected '\"'");
        }
    }

    static {
        WHITESPACE.set(32);
        WHITESPACE.set(9);
        WHITESPACE.set(13);
        WHITESPACE.set(10);
        SEPARATOR.set(44);
        SEPARATOR.set(59);
        RESERVED.set(40);
        RESERVED.set(41);
        RESERVED.set(43);
        RESERVED.set(45);
        RESERVED.set(34);
        UNQUOTED.set(0, 65535, true);
        UNQUOTED.andNot(SEPARATOR);
        UNQUOTED.andNot(RESERVED);
        UNQUOTED.set(45);
        QUOTED.set(0, 65535, true);
        QUOTED.clear(34);
        QUOTED.clear(92);
    }
}

