/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ActivityReportEntry {
    private Date from;
    private Date to;
    private String userName;
    private ConfluenceUser user;
    private boolean printHeader;
    private boolean printState;
    private PageState pageState;
    private List<ActivityEntry> activityEntries;

    public ActivityReportEntry(ActivityEntry entry, ConfluenceUser user) {
        this.from = entry.getFromDate();
        this.to = entry.getToDate();
        this.userName = entry.getActivity().getPerformer();
        this.activityEntries = new ArrayList<ActivityEntry>();
        this.addActivityEntry(entry);
        this.printHeader = true;
        this.user = user;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public boolean isPrintState() {
        return this.printState;
    }

    public void setPrintState(boolean printState) {
        this.printState = printState;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public String getUserName() {
        return this.userName;
    }

    public PageState getPageState() {
        return this.pageState;
    }

    public void addActivityEntry(ActivityEntry entry) {
        if (entry.getPageState() != null) {
            this.pageState = entry.getPageState();
        }
        this.activityEntries.add(entry);
    }

    public List<ActivityEntry> getActivityEntries() {
        return this.activityEntries;
    }

    public List<String> getActivityUsers() {
        return this.activityEntries.get(0).getActivityUsers();
    }

    public String toString() {
        return "ActivityReportEntry{from=" + this.from + ", to=" + this.to + ", user='" + this.userName + "', activityEntries=" + this.activityEntries + "}";
    }

    public ConfluenceUser getUser() {
        return this.user;
    }
}

