/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.service.mapper;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.usage.accessor.model.PageWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.RestrictionsWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.SpaceWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.WorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.rest.model.WorkflowsReport;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.Objects;

public class WorkflowsUsageTaskMapper {
    private final LongRunningTaskManager longRunningTaskManager;
    public static final String DOWNLOAD_URL = "/rest/cw/2/report/workflowsusage/csv?type=";

    public WorkflowsUsageTaskMapper(@ComponentImport LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public WorkflowsUsageTask fromPageWorkflowsRecordToModel(PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord) {
        if (Objects.isNull(pageWorkflowReportTaskRecord)) {
            return WorkflowsUsageTask.builder().status(Status.NOT_RUN).build();
        }
        WorkflowsUsageTask workflowsUsageTask = this.mapWorkflowsUsageTask(pageWorkflowReportTaskRecord);
        if (Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus())) {
            workflowsUsageTask.setDownloadUrl(DOWNLOAD_URL + WorkflowsReport.PAGE.getName());
        }
        return workflowsUsageTask;
    }

    public WorkflowsUsageTask fromSpaceWorkflowsRecordToModel(SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord) {
        if (Objects.isNull(spaceWorkflowReportTaskRecord)) {
            return WorkflowsUsageTask.builder().status(Status.NOT_RUN).build();
        }
        WorkflowsUsageTask workflowsUsageTask = this.mapWorkflowsUsageTask(spaceWorkflowReportTaskRecord);
        if (Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus())) {
            workflowsUsageTask.setDownloadUrl(DOWNLOAD_URL + WorkflowsReport.SPACE.getName());
        }
        return workflowsUsageTask;
    }

    public WorkflowsUsageTask fromRestrictionsWorkflowsRecordToModel(RestrictionsWorkflowReportTaskRecord restrictionsWorkflowReportTaskRecord) {
        if (Objects.isNull(restrictionsWorkflowReportTaskRecord)) {
            return WorkflowsUsageTask.builder().status(Status.NOT_RUN).build();
        }
        WorkflowsUsageTask workflowsUsageTask = this.mapWorkflowsUsageTask(restrictionsWorkflowReportTaskRecord);
        if (Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus())) {
            workflowsUsageTask.setDownloadUrl(DOWNLOAD_URL + WorkflowsReport.RESTRICTIONS.getName());
        }
        return workflowsUsageTask;
    }

    public PageWorkflowReportTaskRecord fromModelToPageWorkflowsRecord(WorkflowsUsageTask workflowsUsageTask) {
        return (PageWorkflowReportTaskRecord)this.fromModelToWorkflowsRecord(new PageWorkflowReportTaskRecord(), workflowsUsageTask);
    }

    public SpaceWorkflowReportTaskRecord fromModelToSpaceWorkflowsRecord(WorkflowsUsageTask workflowsUsageTask) {
        return (SpaceWorkflowReportTaskRecord)this.fromModelToWorkflowsRecord(new SpaceWorkflowReportTaskRecord(), workflowsUsageTask);
    }

    public RestrictionsWorkflowReportTaskRecord fromModelToRestrictionsWorkflowsRecord(WorkflowsUsageTask workflowsUsageTask) {
        return (RestrictionsWorkflowReportTaskRecord)this.fromModelToWorkflowsRecord(new RestrictionsWorkflowReportTaskRecord(), workflowsUsageTask);
    }

    private WorkflowsUsageTask mapWorkflowsUsageTask(WorkflowReportTaskRecord workflowReportTaskRecord) {
        WorkflowsUsageTask workflowsUsageTask = new WorkflowsUsageTask();
        workflowsUsageTask.setStatus(workflowReportTaskRecord.getStatus());
        workflowsUsageTask.setStartedAt(workflowReportTaskRecord.getStartedAt());
        workflowsUsageTask.setDuration(workflowReportTaskRecord.getDuration());
        String taskId = workflowReportTaskRecord.getLongRunningTaskId();
        if (!Status.SUCCESS.equals((Object)workflowsUsageTask.getStatus()) && taskId != null) {
            LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
            if (longRunningTask != null) {
                workflowsUsageTask.setProgress(longRunningTask.getPercentageComplete());
            }
        }
        return workflowsUsageTask;
    }

    private WorkflowReportTaskRecord fromModelToWorkflowsRecord(WorkflowReportTaskRecord workflowReportTaskRecord, WorkflowsUsageTask workflowsUsageTask) {
        if (Objects.isNull(workflowsUsageTask)) {
            return workflowReportTaskRecord;
        }
        workflowReportTaskRecord.setStatus(workflowsUsageTask.getStatus());
        workflowReportTaskRecord.setStartedAt(workflowsUsageTask.getStartedAt());
        workflowReportTaskRecord.setDuration(workflowsUsageTask.getDuration());
        workflowReportTaskRecord.setLongRunningTaskId(workflowsUsageTask.getLongRunningTaskId());
        return workflowReportTaskRecord;
    }
}

