/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.rest.resources;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.util.validators.PermissionValidator;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.usage.manager.WorkflowUsageManager;
import com.comalatech.confluence.workflow.usage.rest.model.RestWorkflowsUsageCancelRequest;
import com.comalatech.confluence.workflow.usage.rest.model.RestWorkflowsUsageRunRequest;
import com.comalatech.confluence.workflow.usage.rest.model.RestWorkflowsUsageStatus;
import com.comalatech.confluence.workflow.usage.rest.model.RestWorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.rest.model.WorkflowsReport;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/report/workflowsusage")
@Produces(value={"application/json"})
public class WorkflowUsageResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUsageResource.class);
    private static final String PERMISSION_VALIDATION_ERROR = "Permission validation error. {0} ";
    private final PermissionValidator permissionValidator;
    private final WorkflowUsageManager workflowUsageManager;
    private final WorkflowsUsageReportService workflowsUsageReportService;

    @Inject
    public WorkflowUsageResource() {
        this.permissionValidator = PluginContainerManager.getComponent("adminPermissionValidator", PermissionValidator.class);
        this.workflowUsageManager = PluginContainerManager.getComponent(WorkflowUsageManager.class);
        this.workflowsUsageReportService = PluginContainerManager.getComponent(WorkflowsUsageReportService.class);
    }

    @Autowired
    public WorkflowUsageResource(@Qualifier(value="adminPermissionValidator") PermissionValidator permissionValidator, WorkflowUsageManager workflowUsageManager, WorkflowsUsageReportService workflowsUsageReportService) {
        this.permissionValidator = permissionValidator;
        this.workflowUsageManager = workflowUsageManager;
        this.workflowsUsageReportService = workflowsUsageReportService;
    }

    @GET
    @Path(value="/status")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    public Response getWorkflowUsageReportStatus() {
        try {
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validate(allAnnotations);
            WorkflowsUsageTask pageWorkflowsUsageReportTask = this.workflowsUsageReportService.getPageWorkflowsUsageReportTask();
            WorkflowsUsageTask spaceWorkflowsUsageReportTask = this.workflowsUsageReportService.getSpaceWorkflowsUsageReportTask();
            WorkflowsUsageTask restrictionsWorkflowUsageReportTask = this.workflowsUsageReportService.getRestrictionsWorkflowUsageReportTask();
            return Response.ok((Object)this.buildWorkflowUsageStatus(pageWorkflowsUsageReportTask, spaceWorkflowsUsageReportTask, restrictionsWorkflowUsageReportTask)).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format(PERMISSION_VALIDATION_ERROR, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
        catch (Exception e) {
            String errorMsg = "Unable to retrieve Workflow usage Report Status";
            log.error("Unable to retrieve Workflow usage Report Status", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/run")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    public Response runWorkflowUsageReport(RestWorkflowsUsageRunRequest request) {
        try {
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validate(allAnnotations);
            WorkflowsUsageTask workflowsUsageTask = this.launchWorkflowsUsageTask(request);
            if (Objects.isNull(workflowsUsageTask)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)this.buildWorkflowsUsageTask(workflowsUsageTask)).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format(PERMISSION_VALIDATION_ERROR, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to run workflow usage report for this type: {0}", request.getType());
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private WorkflowsUsageTask launchWorkflowsUsageTask(RestWorkflowsUsageRunRequest request) {
        switch (request.getType()) {
            case "page": {
                return this.workflowUsageManager.launchPageWorkflowsReport();
            }
            case "space": {
                return this.workflowUsageManager.launchSpaceWorkflowsReport();
            }
            case "restrictions": {
                return this.workflowUsageManager.launchRestrictionsWorkflowsReport();
            }
        }
        return null;
    }

    @POST
    @Path(value="/cancel")
    @ReadOnlyAccessAllowed
    @PermissionRequired(value={"ADMINISTER"})
    public Response cancelWorkflowUsageReport(RestWorkflowsUsageCancelRequest request) {
        try {
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validate(allAnnotations);
            WorkflowsUsageTask workflowsUsageTask = this.getWorkflowsUsageTask(request);
            if (Objects.isNull(workflowsUsageTask)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (Status.IN_PROGRESS.equals((Object)workflowsUsageTask.getStatus())) {
                this.workflowUsageManager.cancelWorkflowUsageReport(request.getType());
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format(PERMISSION_VALIDATION_ERROR, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to cancel workflow usage report for this type: {0}", request.getType());
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private WorkflowsUsageTask getWorkflowsUsageTask(RestWorkflowsUsageCancelRequest request) {
        switch (request.getType()) {
            case "page": {
                return this.workflowsUsageReportService.getPageWorkflowsUsageReportTask();
            }
            case "space": {
                return this.workflowsUsageReportService.getSpaceWorkflowsUsageReportTask();
            }
            case "restrictions": {
                return this.workflowsUsageReportService.getRestrictionsWorkflowUsageReportTask();
            }
        }
        return null;
    }

    @GET
    @Path(value="/csv")
    @ReadOnlyAccessAllowed
    @PermissionRequired(value={"ADMINISTER"})
    public Response getUsageReportCsv(@QueryParam(value="type") String type) {
        try {
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validate(allAnnotations);
            if (!Set.of(WorkflowsReport.PAGE.getName(), WorkflowsReport.SPACE.getName(), WorkflowsReport.RESTRICTIONS.getName()).contains(type)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            java.nio.file.Path csvZipPath = this.workflowsUsageReportService.getCsvFile(type);
            StreamingOutput stream = outputStream -> Files.copy(csvZipPath, outputStream);
            return Response.ok((Object)stream, (String)"application/octet-stream").header("Content-Length", (Object)String.valueOf(Files.size(csvZipPath))).header("Content-Disposition", (Object)("attachment; filename=" + csvZipPath.getFileName().toString())).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format(PERMISSION_VALIDATION_ERROR, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
        catch (IOException e) {
            String errorMsg = MessageFormat.format("Unable to download the zip file for the report. {0}", e.getMessage());
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private RestWorkflowsUsageTask buildWorkflowsUsageTask(WorkflowsUsageTask workflowsUsageTask) {
        return new RestWorkflowsUsageTask(workflowsUsageTask);
    }

    private RestWorkflowsUsageStatus buildWorkflowUsageStatus(WorkflowsUsageTask pageWorkflowUsageTask, WorkflowsUsageTask spaceWorkflowUsageTask, WorkflowsUsageTask restrictionsWorkflowUsageReportTask) {
        return new RestWorkflowsUsageStatus(this.buildWorkflowsUsageTask(pageWorkflowUsageTask), this.buildWorkflowsUsageTask(spaceWorkflowUsageTask), this.buildWorkflowsUsageTask(restrictionsWorkflowUsageReportTask));
    }
}

