/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.SpaceUIConfigDao;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportColumn;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.comalatech.confluence.workflowreports.model.SpaceReportSettings;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/spaceui")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SpaceUIConfigResource
extends AbstractRestResource {
    private final SpaceUIConfigDao spaceUIConfigDao;

    @Inject
    public SpaceUIConfigResource() {
        this.spaceUIConfigDao = PluginContainerManager.getComponent(SpaceUIConfigDao.class);
    }

    @Autowired
    public SpaceUIConfigResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, SpaceUIConfigDao spaceUIConfigDao, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.spaceUIConfigDao = spaceUIConfigDao;
    }

    @PUT
    @PermissionRequired(value={"ADMINISTER"})
    @Path(value="/{spaceKey}")
    public Response saveSpaceUIConfig(final @PathParam(value="spaceKey") String spaceKey, final List<RestSpaceReportColumn> spaceReportColumns) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                SpaceReportSettings spaceReportSettings = new SpaceReportSettings(spaceReportColumns);
                SpaceUIConfigResource.this.spaceUIConfigDao.setSpaceUIConfig(spaceKey, spaceReportSettings);
                return Response.ok(spaceReportSettings.getRestSettings(), (String)"application/json").build();
            }
        }.execute();
    }

    @GET
    @PermissionRequired(value={"VIEW"})
    @Path(value="/{spaceKey}")
    public Response getWorkflowReportSettings(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                SpaceReportSettings spaceReportSettings = SpaceUIConfigResource.this.spaceUIConfigDao.getSpaceUIConfig(spaceKey);
                return Response.ok(spaceReportSettings.getRestSettings(), (String)"application/json").build();
            }
        }.execute();
    }
}

