/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentCreateEvent;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentResolveEvent;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportSuccessEvent;
import com.comalatech.confluence.readack.events.ReadAckCompletedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckCreatedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckOverdueEventImpl;
import com.comalatech.confluence.readack.events.ReadAcknowledgedEventImpl;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.page.PageStateTransitionEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.DummyTaskAssignEvent;
import com.comalatech.confluence.tasks.event.DummyTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.DummyTaskCreateEvent;
import com.comalatech.confluence.tasks.event.DummyTaskDueDateExpiredEvent;
import com.comalatech.confluence.tasks.event.TaskAssignEvent;
import com.comalatech.confluence.tasks.event.TaskCompleteEvent;
import com.comalatech.confluence.tasks.event.TaskCreateEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentCreateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentUpdateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentVersionRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.events.WorkflowPageParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.confluence.workflow.restv2.model.RestEvent;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.comalatech.workflow.event.TaskEvent;
import com.comalatech.workflow.event.WorkflowPageParameterUpdatedEvent;
import com.comalatech.workflow.event.readack.ReadAckCompletedEvent;
import com.comalatech.workflow.event.readack.ReadAckCreatedEvent;
import com.comalatech.workflow.event.readack.ReadAckOverdueEvent;
import com.comalatech.workflow.event.readack.ReadAcknowledgedEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMapper
implements Mapper<ConfluenceEvent, RestEvent> {
    private static final Logger log = LoggerFactory.getLogger(EventMapper.class);
    private static final String PAGE = "page";
    private static final String BLOG = "blog";
    public static final Class<? extends ConfluenceEvent>[] EVENTS = new Class[]{LabelAddEvent.class, LabelRemoveEvent.class, PageApprovalApproveEvent.class, PageApprovalRejectEvent.class, PageApprovalAssignedEvent.class, BlogPostApprovalApproveEvent.class, BlogPostApprovalRejectEvent.class, BlogPostApprovalAssignedEvent.class, DefaultApprovalUnassignedEvent.class, PageCreateEvent.class, PageUpdateEvent.class, PageMoveEvent.class, BlogPostCreateEvent.class, BlogPostUpdateEvent.class, PageStateTransitionEvent.class, StateExpireEvent.class, StateExpiryUpdatedEvent.class, BlogPostStateTransitionEvent.class, WorkflowAttachmentCreateEvent.class, WorkflowAttachmentUpdateEvent.class, WorkflowAttachmentRemoveEvent.class, WorkflowAttachmentVersionRemoveEvent.class, WorkflowAttachmentChangedEvent.class, TaskCreateEvent.class, TaskAssignEvent.class, TaskCompleteEvent.class, TaskDueDateExpiredEvent.class, WorkflowPageParameterUpdatedEvent.class, CommentCreateEvent.class, CommentUpdateEvent.class, CommentRemoveEvent.class, InlineCommentCreateEvent.class, InlineCommentResolveEvent.class, WorkflowCustomEvent.class, ReadAckCompletedEvent.class, ReadAckCreatedEvent.class, ReadAckOverdueEvent.class, ReadAcknowledgedEvent.class, PdfExportSuccessEvent.class, PdfExportErrorEvent.class};

    @Override
    public RestEvent toRest(ConfluenceEvent event) {
        for (Class<? extends ConfluenceEvent> aClass : EVENTS) {
            if (!aClass.isInstance(event)) continue;
            try {
                return (RestEvent)this.getClass().getMethod("toRest", aClass).invoke((Object)this, event);
            }
            catch (NoSuchMethodException e) {
                throw new MapperException("toRest support for class " + aClass.getName() + " is still not implemented", e);
            }
            catch (InvocationTargetException e) {
                throw new MapperException("cannot call to toRest(" + aClass.getName() + ")", e);
            }
            catch (IllegalAccessException e) {
                throw new MapperException("No access trying to call toRest(" + aClass.getName() + ")", e);
            }
        }
        if (event instanceof LabelAddEvent) {
            return this.toRest((LabelAddEvent)event);
        }
        if (event instanceof LabelRemoveEvent) {
            return this.toRest((LabelRemoveEvent)event);
        }
        if (event instanceof PageApprovalApproveEvent) {
            return this.toRest((PageApprovalApproveEvent)event);
        }
        if (event instanceof PageApprovalRejectEvent) {
            return this.toRest((PageApprovalRejectEvent)event);
        }
        if (event instanceof PageApprovalAssignedEvent) {
            return this.toRest((PageApprovalAssignedEvent)event);
        }
        if (event instanceof BlogPostApprovalApproveEvent) {
            return this.toRest((BlogPostApprovalApproveEvent)event);
        }
        if (event instanceof BlogPostApprovalRejectEvent) {
            return this.toRest((BlogPostApprovalRejectEvent)event);
        }
        if (event instanceof BlogPostApprovalAssignedEvent) {
            return this.toRest((BlogPostApprovalAssignedEvent)event);
        }
        if (event instanceof DefaultApprovalUnassignedEvent) {
            return this.toRest((DefaultApprovalUnassignedEvent)event);
        }
        if (event instanceof PageCreateEvent) {
            return this.toRest((PageCreateEvent)event);
        }
        if (event instanceof PageUpdateEvent) {
            return this.toRest((PageUpdateEvent)event);
        }
        if (event instanceof PageMoveEvent) {
            return this.toRest((PageMoveEvent)event);
        }
        if (event instanceof BlogPostCreateEvent) {
            return this.toRest((BlogPostCreateEvent)event);
        }
        if (event instanceof BlogPostUpdateEvent) {
            return this.toRest((BlogPostUpdateEvent)event);
        }
        if (event instanceof PageStateTransitionEvent) {
            return this.toRest((PageStateTransitionEvent)event);
        }
        if (event instanceof StateExpireEvent) {
            return this.toRest((StateExpireEvent)event);
        }
        if (event instanceof StateExpiryUpdatedEvent) {
            return this.toRest((StateExpiryUpdatedEvent)event);
        }
        if (event instanceof BlogPostStateTransitionEvent) {
            return this.toRest((BlogPostStateTransitionEvent)event);
        }
        if (event instanceof WorkflowAttachmentCreateEvent) {
            return this.toRest((WorkflowAttachmentCreateEvent)event);
        }
        if (event instanceof WorkflowAttachmentUpdateEvent) {
            return this.toRest((WorkflowAttachmentUpdateEvent)event);
        }
        if (event instanceof WorkflowAttachmentRemoveEvent) {
            return this.toRest((WorkflowAttachmentRemoveEvent)event);
        }
        if (event instanceof WorkflowAttachmentVersionRemoveEvent) {
            return this.toRest((WorkflowAttachmentVersionRemoveEvent)event);
        }
        if (event instanceof WorkflowAttachmentChangedEvent) {
            return this.toRest((WorkflowAttachmentChangedEvent)event);
        }
        if (event instanceof TaskCreateEvent) {
            return this.toRest((TaskCreateEvent)event);
        }
        if (event instanceof TaskAssignEvent) {
            return this.toRest((TaskAssignEvent)event);
        }
        if (event instanceof TaskCompleteEvent) {
            return this.toRest((TaskCompleteEvent)event);
        }
        if (event instanceof TaskDueDateExpiredEvent) {
            return this.toRest((TaskDueDateExpiredEvent)event);
        }
        if (event instanceof WorkflowPageParameterUpdatedEvent) {
            return this.toRest((WorkflowPageParameterUpdatedEvent)event);
        }
        if (event instanceof CommentCreateEvent) {
            return this.toRest((CommentCreateEvent)event);
        }
        if (event instanceof CommentUpdateEvent) {
            return this.toRest((CommentUpdateEvent)event);
        }
        if (event instanceof CommentRemoveEvent) {
            return this.toRest((CommentRemoveEvent)event);
        }
        if (event instanceof InlineCommentCreateEvent) {
            return this.toRest((InlineCommentCreateEvent)event);
        }
        if (event instanceof InlineCommentResolveEvent) {
            return this.toRest((InlineCommentResolveEvent)event);
        }
        if (event instanceof ReadAckOverdueEvent) {
            return this.toRest((ReadAckOverdueEvent)event);
        }
        if (event instanceof ReadAckCompletedEvent) {
            return this.toRest((ReadAckCompletedEvent)event);
        }
        if (event instanceof ReadAckCreatedEvent) {
            return this.toRest((ReadAckCreatedEvent)event);
        }
        if (event instanceof ReadAcknowledgedEvent) {
            return this.toRest((ReadAcknowledgedEvent)event);
        }
        log.warn("Unknown concrete Event subclass: " + event.getClass());
        return null;
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent restEvent) {
        if (restEvent instanceof RestEvent.RestLabelEvent) {
            return this.fromRest((RestEvent.RestLabelEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestApprovalEvent) {
            return this.fromRest((RestEvent.RestApprovalEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestContentEvent) {
            return this.fromRest((RestEvent.RestContentEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestStateEvent) {
            return this.fromRest((RestEvent.RestStateEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestAttachmentEvent) {
            return this.fromRest((RestEvent.RestAttachmentEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestTaskEvent) {
            return this.fromRest((RestEvent.RestTaskEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestWorkflowPageParameterEvent) {
            return this.fromRest((RestEvent.RestWorkflowPageParameterEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestCustomEvent) {
            return this.fromRest((RestEvent.RestCustomEvent)restEvent);
        }
        if (restEvent instanceof RestEvent.RestReadAckEvent) {
            return this.fromRest((RestEvent.RestReadAckEvent)restEvent);
        }
        log.warn("Unknown concrete RestEvent subclass: " + restEvent.getClass());
        return null;
    }

    public String toMacroName(ConfluenceEvent event) {
        if (event instanceof LabelAddEvent) {
            return "labeladded";
        }
        if (event instanceof LabelRemoveEvent) {
            return "labelremoved";
        }
        if (event instanceof PageApprovalApproveEvent) {
            return "pageapproved";
        }
        if (event instanceof PageApprovalRejectEvent) {
            return "pagerejected";
        }
        if (event instanceof BlogPostApprovalApproveEvent) {
            return "newsapproved";
        }
        if (event instanceof BlogPostApprovalRejectEvent) {
            return "newsrejected";
        }
        if (event instanceof DefaultApprovalUnassignedEvent) {
            return "approvalunassigned";
        }
        if (event instanceof PageCreateEvent) {
            return "pagecreated";
        }
        if (event instanceof PageUpdateEvent) {
            return "pageupdated";
        }
        if (event instanceof PageMoveEvent) {
            return "pagemoved";
        }
        if (event instanceof BlogPostCreateEvent) {
            return "newscreated";
        }
        if (event instanceof BlogPostUpdateEvent) {
            return "newsupdated";
        }
        if (event instanceof PageStateTransitionEvent) {
            if (event.getSource() != null) {
                return ((PageStateTransitionEvent)event).getSourceEvent();
            }
            return "statechanged";
        }
        if (event instanceof StateExpireEvent) {
            return "stateexpired";
        }
        if (event instanceof StateExpiryUpdatedEvent) {
            return "stateexpiryupdated";
        }
        if (event instanceof BlogPostStateTransitionEvent) {
            return "newsstatechanged";
        }
        if (event instanceof WorkflowAttachmentCreateEvent) {
            return "attachmentadded";
        }
        if (event instanceof WorkflowAttachmentUpdateEvent) {
            return "attachmentupdated";
        }
        if (event instanceof WorkflowAttachmentRemoveEvent) {
            return "attachmentremoved";
        }
        if (event instanceof WorkflowAttachmentVersionRemoveEvent) {
            return "attachmentversionremoved";
        }
        if (event instanceof WorkflowAttachmentChangedEvent) {
            return "attachmentschanged";
        }
        if (event instanceof TaskCreateEvent) {
            return "taskcreated";
        }
        if (event instanceof TaskAssignEvent) {
            return "taskassigned";
        }
        if (event instanceof TaskCompleteEvent) {
            return "taskcompleted";
        }
        if (event instanceof TaskDueDateExpiredEvent) {
            return "taskexpired";
        }
        if (event instanceof WorkflowPageParameterUpdatedEvent) {
            return "pageparameterupdate";
        }
        if (event instanceof CommentCreateEvent) {
            return "pagecommentcreated";
        }
        if (event instanceof CommentUpdateEvent) {
            return "pagecommentupdated";
        }
        if (event instanceof CommentRemoveEvent) {
            return "pagecommentremoved";
        }
        if (event instanceof InlineCommentCreateEvent) {
            return "inlinecommentcreated";
        }
        if (event instanceof InlineCommentResolveEvent) {
            return "inlinecommentresolved";
        }
        if (event instanceof ReadAckCreatedEvent) {
            return "confirmationrequested";
        }
        if (event instanceof ReadAckCompletedEvent) {
            return "confirmationcompleted";
        }
        if (event instanceof ReadAckOverdueEvent) {
            return "confirmationdue";
        }
        if (event instanceof ReadAcknowledgedEvent) {
            return "confirmationacknowledged";
        }
        if (event instanceof PdfExportSuccessEvent) {
            return "pdf-export-success";
        }
        if (event instanceof PdfExportErrorEvent) {
            return "pdf-export-error";
        }
        log.warn("Unknown concrete Event subclass to get macro name: " + event.getClass());
        return null;
    }

    @Override
    public RestEvent.RestLabelEvent toRest(LabelAddEvent event) {
        return new RestEvent.RestLabelEvent("label-added", event.getLabel().toString());
    }

    @Override
    public RestEvent.RestLabelEvent toRest(LabelRemoveEvent event) {
        return new RestEvent.RestLabelEvent("label-removed", event.getLabel().toString());
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestLabelEvent restEvent) {
        switch (restEvent.name) {
            case "label-added": {
                return new LabelAddEvent(new Label(restEvent.label), null);
            }
            case "label-removed": {
                return new LabelRemoveEvent(new Label(restEvent.label), null);
            }
        }
        log.warn("Unknown concrete RestLabelEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(PageApprovalApproveEvent event) {
        return new RestEvent.RestApprovalEvent("approval-approved", PAGE, event.getApprovalName(), event.isPartial());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(PageApprovalRejectEvent event) {
        return new RestEvent.RestApprovalEvent("approval-rejected", PAGE, event.getApprovalName(), event.isPartial());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(PageApprovalAssignedEvent event) {
        return new RestEvent.RestApprovalEvent("approval-assigned", PAGE, event.getApprovalName());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(BlogPostApprovalApproveEvent event) {
        return new RestEvent.RestApprovalEvent("approval-approved", BLOG, event.getApprovalName(), event.isPartial());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(BlogPostApprovalRejectEvent event) {
        return new RestEvent.RestApprovalEvent("approval-rejected", BLOG, event.getApprovalName(), event.isPartial());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(BlogPostApprovalAssignedEvent event) {
        return new RestEvent.RestApprovalEvent("approval-assigned", BLOG, event.getApprovalName());
    }

    @Override
    public RestEvent.RestApprovalEvent toRest(DefaultApprovalUnassignedEvent event) {
        return new RestEvent.RestApprovalEvent("approval-unassigned", null, event.getApprovalName());
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestApprovalEvent restEvent) {
        Page dummyPage = new Page();
        BlogPost dummyBlogPost = new BlogPost();
        boolean partial = BooleanUtils.isTrue((Boolean)restEvent.partial);
        switch (restEvent.name) {
            case "approval-approved": {
                return restEvent.content.equals(BLOG) ? new BlogPostApprovalApproveEvent(this, dummyBlogPost, null, new ApprovalCheck(restEvent.approval), partial) : new PageApprovalApproveEvent(this, dummyPage, null, new ApprovalCheck(restEvent.approval), partial);
            }
            case "approval-rejected": {
                return restEvent.content.equals(BLOG) ? new BlogPostApprovalRejectEvent(this, dummyBlogPost, null, new ApprovalCheck(restEvent.approval), partial) : new PageApprovalRejectEvent(this, dummyPage, null, new ApprovalCheck(restEvent.approval), partial);
            }
            case "approval-assigned": {
                return restEvent.content.equals(BLOG) ? new BlogPostApprovalAssignedEvent(this, dummyBlogPost, null, new ApprovalCheck(restEvent.approval), partial, null, null) : new PageApprovalAssignedEvent(this, dummyPage, null, new ApprovalCheck(restEvent.approval), partial, null, null);
            }
            case "approval-unassigned": {
                return new DefaultApprovalUnassignedEvent(this, new ApprovalCheck(restEvent.approval), null, null, false, null);
            }
        }
        log.warn("Unknown concrete RestApprovalEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestContentEvent toRest(PageCreateEvent event) {
        return new RestEvent.RestContentEvent("page-created");
    }

    @Override
    public RestEvent.RestContentEvent toRest(PageUpdateEvent event) {
        return new RestEvent.RestContentEvent("page-update");
    }

    @Override
    public RestEvent.RestContentEvent toRest(PageMoveEvent event) {
        return new RestEvent.RestContentEvent("page-moved");
    }

    @Override
    public RestEvent.RestContentEvent toRest(BlogPostCreateEvent event) {
        return new RestEvent.RestContentEvent("blog-created");
    }

    @Override
    public RestEvent.RestContentEvent toRest(BlogPostUpdateEvent event) {
        return new RestEvent.RestContentEvent("blog-update");
    }

    @Override
    public RestEvent.RestContentEvent toRest(CommentCreateEvent event) {
        return new RestEvent.RestContentEvent("page-comment-created");
    }

    @Override
    public RestEvent.RestContentEvent toRest(CommentUpdateEvent event) {
        return new RestEvent.RestContentEvent("page-comment-updated");
    }

    @Override
    public RestEvent.RestContentEvent toRest(CommentRemoveEvent event) {
        return new RestEvent.RestContentEvent("page-comment-removed");
    }

    @Override
    public RestEvent.RestContentEvent toRest(InlineCommentCreateEvent event) {
        return new RestEvent.RestContentEvent("inline-comment-created");
    }

    @Override
    public RestEvent.RestContentEvent toRest(InlineCommentResolveEvent event) {
        return new RestEvent.RestContentEvent("inline-comment-resolved");
    }

    @Override
    public RestEvent.RestContentEvent toRest(PdfExportSuccessEvent pdfExportEvent) {
        return new RestEvent.RestContentEvent("pdf-export-success");
    }

    @Override
    public RestEvent.RestContentEvent toRest(PdfExportErrorEvent pdfExportEvent) {
        return new RestEvent.RestContentEvent("pdf-export-error");
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestContentEvent restEvent) {
        Page dummyPage = new Page();
        BlogPost dummyBlogPost = new BlogPost();
        Space dummySpace = new Space();
        switch (restEvent.name) {
            case "page-created": {
                return new PageCreateEvent((Object)this, dummyPage);
            }
            case "page-update": {
                return new PageUpdateEvent((Object)this, dummyPage, null, false, PageUpdateTrigger.UNKNOWN);
            }
            case "page-moved": {
                return new PageMoveEvent((Object)this, dummyPage, new ArrayList(), dummySpace, null, null, null, false);
            }
            case "blog-created": {
                return new BlogPostCreateEvent((Object)this, dummyBlogPost);
            }
            case "blog-update": {
                return new BlogPostUpdateEvent((Object)this, dummyBlogPost, null);
            }
            case "page-comment-created": {
                return new CommentCreateEvent((Object)this, new Comment());
            }
            case "page-comment-updated": {
                return new CommentUpdateEvent((Object)this, new Comment());
            }
            case "page-comment-removed": {
                return new CommentRemoveEvent((Object)this, new Comment(), null);
            }
            case "inline-comment-created": {
                return new InlineCommentCreateEvent((Object)this, new Comment());
            }
            case "inline-comment-resolved": {
                return new InlineCommentResolveEvent((Object)this, new Comment());
            }
            case "pdf-export-success": {
                return new PdfExportSuccessEvent(this, (AbstractPage)dummyPage, null, null);
            }
            case "pdf-export-error": {
                return new PdfExportErrorEvent((Object)this, (AbstractPage)dummyPage, null, "");
            }
        }
        log.warn("Unknown concrete RestContentEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestStateEvent toRest(PageStateTransitionEvent event) {
        RestEvent.RestStateEvent stateEvent = new RestEvent.RestStateEvent("state-changed", event.getState().getName(), event.isInitial());
        stateEvent.sourceEvent = event.getSourceEvent();
        return stateEvent;
    }

    @Override
    public RestEvent.RestStateEvent toRest(StateExpireEvent event) {
        return new RestEvent.RestStateEvent("state-expired", event.getState().getName(), false);
    }

    @Override
    public RestEvent.RestStateEvent toRest(StateExpiryUpdatedEvent event) {
        return new RestEvent.RestStateEvent("state-expiry-updated", event.getState().getName(), false);
    }

    @Override
    public RestEvent.RestStateEvent toRest(BlogPostStateTransitionEvent event) {
        return new RestEvent.RestStateEvent("blog-state-changed", event.getState().getName(), false);
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestStateEvent restEvent) {
        Page dummyPage = new Page();
        BlogPost dummyBlogPost = new BlogPost();
        switch (restEvent.name) {
            case "state-changed": {
                PageStateTransitionEvent pageStateTransitionEvent = new PageStateTransitionEvent(this, dummyPage, null, new PageState(restEvent.state));
                pageStateTransitionEvent.setInitial(BooleanUtils.isTrue((Boolean)restEvent.initial));
                if (restEvent.sourceEvent != null) {
                    pageStateTransitionEvent.setSourceEvent(restEvent.sourceEvent);
                }
                return pageStateTransitionEvent;
            }
            case "state-expired": {
                return new StateExpireEvent(this, (AbstractPage)dummyPage, new PageState(restEvent.state), null);
            }
            case "state-expiry-updated": {
                return new StateExpiryUpdatedEvent(this, (AbstractPage)dummyPage, new PageState(restEvent.state));
            }
            case "blog-state-changed": {
                return new BlogPostStateTransitionEvent(this, dummyBlogPost, null, new PageState(restEvent.state));
            }
        }
        log.warn("Unknown concrete RestStateEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestAttachmentEvent toRest(WorkflowAttachmentCreateEvent event) {
        return new RestEvent.RestAttachmentEvent("attachment-added");
    }

    @Override
    public RestEvent.RestAttachmentEvent toRest(WorkflowAttachmentRemoveEvent event) {
        return new RestEvent.RestAttachmentEvent("attachment-removed");
    }

    @Override
    public RestEvent.RestAttachmentEvent toRest(WorkflowAttachmentVersionRemoveEvent event) {
        return new RestEvent.RestAttachmentEvent("attachment-version-removed");
    }

    @Override
    public RestEvent.RestAttachmentEvent toRest(WorkflowAttachmentUpdateEvent event) {
        return new RestEvent.RestAttachmentEvent("attachment-updated");
    }

    @Override
    public RestEvent.RestAttachmentEvent toRest(WorkflowAttachmentChangedEvent event) {
        return new RestEvent.RestAttachmentEvent("attachment-change");
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestAttachmentEvent restEvent) {
        Page dummyPage = new Page();
        switch (restEvent.name) {
            case "attachment-added": {
                return new WorkflowAttachmentCreateEvent(this, null, (AbstractPage)dummyPage);
            }
            case "attachment-removed": {
                return new WorkflowAttachmentRemoveEvent(this, null, (AbstractPage)dummyPage);
            }
            case "attachment-version-removed": {
                return new WorkflowAttachmentVersionRemoveEvent(this, null, (AbstractPage)dummyPage);
            }
            case "attachment-updated": {
                return new WorkflowAttachmentUpdateEvent(this, null, (AbstractPage)dummyPage);
            }
            case "attachment-change": {
                return new WorkflowAttachmentChangedEvent(this, null, (AbstractPage)dummyPage);
            }
        }
        log.warn("Unknown concrete RestAttachmentEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestTaskEvent toRest(TaskCreateEvent event) {
        return new RestEvent.RestTaskEvent("task-created", EventMapper.getTaskName(event), EventMapper.getStateName(event));
    }

    @Override
    public RestEvent.RestTaskEvent toRest(TaskAssignEvent event) {
        return new RestEvent.RestTaskEvent("task-assigned", EventMapper.getTaskName(event), EventMapper.getStateName(event));
    }

    @Override
    public RestEvent.RestTaskEvent toRest(TaskCompleteEvent event) {
        return new RestEvent.RestTaskEvent("task-completed", EventMapper.getTaskName(event), EventMapper.getStateName(event));
    }

    @Override
    public RestEvent.RestTaskEvent toRest(TaskDueDateExpiredEvent event) {
        return new RestEvent.RestTaskEvent("task-expired", EventMapper.getTaskName(event), EventMapper.getStateName(event));
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestTaskEvent restEvent) {
        Page dummyPage = new Page();
        switch (restEvent.name) {
            case "task-created": {
                return new DummyTaskCreateEvent(restEvent.task, restEvent.state);
            }
            case "task-assigned": {
                return new DummyTaskAssignEvent(restEvent.task, restEvent.state);
            }
            case "task-completed": {
                return new DummyTaskCompleteEvent(restEvent.task, restEvent.state);
            }
            case "task-expired": {
                return new DummyTaskDueDateExpiredEvent(restEvent.task, restEvent.state);
            }
        }
        log.warn("Unknown concrete RestTaskEvent subclass: " + restEvent.getClass());
        return null;
    }

    @Override
    public RestEvent.RestWorkflowPageParameterEvent toRest(WorkflowPageParameterUpdatedEvent event) {
        return new RestEvent.RestWorkflowPageParameterEvent("parameter-updated", event.getWorkflowParameter().getName());
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestWorkflowPageParameterEvent restEvent) {
        Page dummyPage = new Page();
        return new WorkflowPageParameterUpdatedEventImpl(this, (AbstractPage)dummyPage, null, new WorkflowParameter(restEvent.parameter, "", null, "", "", true));
    }

    @Override
    public RestEvent.RestCustomEvent toRest(WorkflowCustomEvent event) {
        return new RestEvent.RestCustomEvent("custom", event.isSuccess());
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestCustomEvent restEvent) {
        Page dummyPage = new Page();
        return new WorkflowCustomEvent("", (AbstractPage)dummyPage, restEvent.name, restEvent.success, "");
    }

    @Override
    public RestEvent.RestReadAckEvent toRest(ReadAckOverdueEvent event) {
        return new RestEvent.RestReadAckEvent("readack-overdue", PAGE);
    }

    @Override
    public RestEvent.RestReadAckEvent toRest(ReadAckCompletedEvent event) {
        return new RestEvent.RestReadAckEvent("readack-completed", PAGE, event.getAckTimestamp());
    }

    @Override
    public RestEvent.RestReadAckEvent toRest(ReadAckCreatedEvent event) {
        return new RestEvent.RestReadAckEvent("readack-created", PAGE, event.getUsers());
    }

    @Override
    public RestEvent.RestReadAckEvent toRest(ReadAcknowledgedEvent event) {
        return new RestEvent.RestReadAckEvent("readack-acknowledged", PAGE);
    }

    @Override
    public ConfluenceEvent fromRest(RestEvent.RestReadAckEvent restEvent) {
        Page dummyPage = new Page();
        switch (restEvent.name) {
            case "readack-overdue": {
                return new ReadAckOverdueEventImpl(this, (AbstractPage)dummyPage);
            }
            case "readack-completed": {
                return new ReadAckCompletedEventImpl(this, (AbstractPage)dummyPage, restEvent.ackTimestamp, null);
            }
            case "readack-created": {
                return new ReadAckCreatedEventImpl(this, (AbstractPage)dummyPage, restEvent.users);
            }
            case "readack-acknowledged": {
                return new ReadAcknowledgedEventImpl(this, (AbstractPage)dummyPage);
            }
        }
        log.warn("Unknown concrete RestReadAckEvent subclass: " + restEvent.getClass());
        return null;
    }

    private static String getStateName(TaskEvent taskEvent) {
        return taskEvent.getState() != null ? taskEvent.getState().getName() : null;
    }

    private static String getTaskName(TaskEvent taskEvent) {
        return taskEvent.getTask() != null ? taskEvent.getTask().getName() : null;
    }
}

