/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.accesor.ContentRestrictionWorkflowRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Component;

@Component
public class ContentRestrictionWorkflowRecordAccessorImpl
implements ContentRestrictionWorkflowRecordAccessor {
    private static final String SPACE_KEYS = "spacekeys";
    private final EntityManagerProvider entityManagerProvider;

    public ContentRestrictionWorkflowRecordAccessorImpl(@ComponentImport EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentRestrictionSpaceWorkflows(List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select content.id as contentId, content.title as title, space.key as key, permissionSet.type as type, permission as permission, contentProperty.stringVal as state from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, ContentPermissionSet permissionSet, ContentPermission permission, BucketPropertySetItem contentProperty where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and contentProperty.entityId = content.id and content.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and (contentProperty.stringVal is not null or contentProperty.textVal is not null) and space.key in (:spacekeys)", Tuple.class);
        query.setParameter(SPACE_KEYS, spaceIdList);
        return query.getResultList().stream().map(queryRecord -> ContentRestrictionWorkflowRecord.map(queryRecord, false)).collect(Collectors.toList());
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> findAllContentInheritedRestrictionSpaceWorkflows(List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select distinct content.id as contentId, content.title as title, space.key as key, permissionSet.type as type, permission as permission, contentProperty.stringVal as state, ancestor.id as ancestorId from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, ContentEntityObject ancestor, ContentPermissionSet permissionSet, ContentPermission permission, BucketPropertySetItem contentProperty where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and ancestor member of content.ancestors and permissionSet.owningContent.id = ancestor.id and permissionSet.id = permission.owningSet.id and contentProperty.entityId = content.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and (contentProperty.stringVal is not null or contentProperty.textVal is not null) and permissionSet.type = 'View'and space.key in (:spacekeys) ", Tuple.class);
        query.setParameter(SPACE_KEYS, spaceIdList);
        return query.getResultList().stream().map(queryRecord -> ContentRestrictionWorkflowRecord.map(queryRecord, true)).collect(Collectors.toList());
    }

    @Override
    public boolean existsContentRestrictionSpaceWorkflows(List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select 1 from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, ContentPermissionSet permissionSet, ContentPermission permission, BucketPropertySetItem contentProperty where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and contentProperty.entityId = content.id and content.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and (contentProperty.stringVal is not null or contentProperty.textVal is not null) and space.key in (:spacekeys)", Tuple.class);
        query.setParameter(SPACE_KEYS, spaceIdList);
        query.setMaxResults(1);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean existsContentInheritedRestrictionSpaceWorkflows(List<String> spaceIdList) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select 1 from ConfluenceBandanaRecord bandana, Space space, ContentEntityObject content, BucketPropertySetItem contentProperty join content.ancestors a where bandana.key like '%com.comalatech.workflow.production.template%' and bandana.context = space.key and content.space.id = space.id and contentProperty.entityId = content.id and content.contentStatus = 'current' and bandana.value not like '%disabled=true%' and contentProperty.key = 'metadata.awpState' and (contentProperty.stringVal is not null or contentProperty.textVal is not null) and a.id in (Select c.id from ContentEntityObject c, ContentPermissionSet permissionSet, ContentPermission permission where c.id = permissionSet.owningContent.id and permissionSet.id = permission.owningSet.id and c.space.id = space.id and permissionSet.type = 'View') and space.key in (:spacekeys) ", Tuple.class);
        query.setParameter(SPACE_KEYS, spaceIdList);
        query.setMaxResults(1);
        return !query.getResultList().isEmpty();
    }
}

