/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImpersonationUtil {
    private static final Logger log = LoggerFactory.getLogger(ImpersonationUtil.class);
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final GroupManager groupManager;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final ContentPermissionManager contentPermissionManager;

    public ImpersonationUtil(WorkflowConfigurationManager workflowConfigurationManager, @ComponentImport GroupManager groupManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport ContentPermissionManager contentPermissionManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean impersonatedOperation(AbstractPage abstractPage, Callable<Boolean> callback) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean success = false;
        ConfluenceUser impersonator = this.getUserForImpersonationWithEditPermission(abstractPage);
        if (impersonator == null) {
            log.warn("Workflows Content Properties cannot be updated/created/deleted in " + abstractPage + " because no valid user was found with edit permissions over it.");
            return false;
        }
        boolean doImpersonation = !impersonator.equals(currentUser);
        try {
            if (doImpersonation) {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)impersonator);
            }
            success = callback.call();
        }
        catch (Exception e) {
            log.error("Error during callback execution", (Throwable)e);
        }
        finally {
            if (doImpersonation) {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
            }
        }
        return success;
    }

    private ConfluenceUser getUserForImpersonationWithEditPermission(AbstractPage abstractPage) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null && this.isUserAllowedToImpersonate(currentUser, abstractPage, "current user")) {
            return currentUser;
        }
        if (this.isUserAllowedToImpersonate(abstractPage.getLastModifier(), abstractPage, "page's last modifier")) {
            return abstractPage.getLastModifier();
        }
        if (this.isUserAllowedToImpersonate(abstractPage.getCreator(), abstractPage, "page's creator")) {
            return abstractPage.getCreator();
        }
        ConfluenceUser restrictionsUser = this.getUserWithEditPermission(abstractPage);
        if (restrictionsUser != null) {
            return restrictionsUser;
        }
        String groupName = this.workflowConfigurationManager.getAdminImpersonatorsGroup();
        if (groupName != null && !groupName.isEmpty()) {
            try {
                Group group = this.groupManager.getGroup(groupName);
                if (log.isDebugEnabled()) {
                    log.debug("Using group: '" + groupName + "' to obtain a valid user to impersonate the operation.");
                }
                for (String username : this.groupManager.getMemberNames(group)) {
                    ConfluenceUser user = this.userAccessor.getUserByName(username);
                    if (!this.isUserAllowedToImpersonate(user, abstractPage, "admin from config")) continue;
                    return user;
                }
            }
            catch (EntityException e) {
                log.error("There was an exception trying to resolve group: " + groupName, (Throwable)e);
            }
        } else {
            log.warn("This thread job has not user set. Some the content properties operations might fail. Use configuration setting for 'Workflow action impersonation user group' to set up a group of user/s with permissions");
        }
        return null;
    }

    private boolean isUserAllowedToImpersonate(ConfluenceUser user, AbstractPage abstractPage, String role) {
        boolean result = this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)abstractPage);
        if (log.isDebugEnabled()) {
            log.debug("User '" + user + "' as " + role + ", has " + (result ? "no " : "") + "edit permissions over '" + abstractPage + "'" + (result ? " and will be temporarily used for impersonation." : ""));
        }
        return result;
    }

    private ConfluenceUser getUserWithEditPermission(AbstractPage page) {
        List permissionSets = this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "Edit");
        if (log.isDebugEnabled()) {
            log.debug("The actual user '" + AuthenticatedUserThreadLocal.get() + "' and none of the contributors of the page " + page + " have edit permission. We will search for a user with edit permissions to be able to execute the update/create/delete of the Workflows Content Properties");
        }
        for (ContentPermissionSet permissionSet : permissionSets) {
            for (UserKey userKey : permissionSet.getUserKeys()) {
                ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
                if (!this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("'" + user + "' has edit permissions on the page " + page + ". Using it to impersonate the operation");
                }
                return user;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("No user found with edit permission.");
        }
        return null;
    }
}

