/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.ContentMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskAssignmentMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskCompletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskCreationMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDeletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateDeletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateExpiryMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskUnassignmentMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DeletionActivity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;
import java.util.ArrayList;
import java.util.List;

public class TasksMapper
extends ContentMapper {
    private final TaskCreationMapper taskCreationMapper;
    private final TaskAssignmentMapper taskAssignmentMapper;
    private final TaskUnassignmentMapper taskUnassignmentMapper;
    private final TaskCompletionMapper taskCompletionMapper;
    private final TaskDeletionMapper taskDeletionMapper;
    private final TaskDueDateDeletionMapper taskDueDateDeletionMapper;
    private final TaskDueDateMapper taskDueDateMapper;
    private final TaskDueDateExpiryMapper taskDueDateExpiryMapper;

    public TasksMapper(PageManager pageManager, ActorUtils actorUtils) {
        super(pageManager);
        this.taskCreationMapper = new TaskCreationMapper(actorUtils);
        this.taskAssignmentMapper = new TaskAssignmentMapper(actorUtils);
        this.taskUnassignmentMapper = new TaskUnassignmentMapper(actorUtils);
        this.taskCompletionMapper = new TaskCompletionMapper(actorUtils);
        this.taskDeletionMapper = new TaskDeletionMapper(actorUtils);
        this.taskDueDateDeletionMapper = new TaskDueDateDeletionMapper(actorUtils);
        this.taskDueDateMapper = new TaskDueDateMapper(actorUtils);
        this.taskDueDateExpiryMapper = new TaskDueDateExpiryMapper(actorUtils);
    }

    public List<Activity> buildTaskActivities(PageState state, PageTask task) throws Exception {
        List<DueDateRecord> dueDateHistoryRecords;
        DueDateRecord currentDueDate;
        DeletionActivity deletionActivity;
        List<TaskCompletion> completions;
        ArrayList<Activity> activities = new ArrayList<Activity>();
        AbstractPage content = this.buildContent(state.getPage(), state.getVersion());
        activities.add(this.taskCreationMapper.buildActivity(content, state, task));
        List<Assignment> assignments = task.getAssignments();
        if (assignments != null && !assignments.isEmpty()) {
            for (Assignment assignment : assignments) {
                if (assignment.getAssignee() != null) {
                    activities.add(this.taskAssignmentMapper.buildActivity(content, state, task, assignment));
                    continue;
                }
                activities.add(this.taskUnassignmentMapper.buildActivity(content, state, task, assignment));
            }
        }
        if ((completions = task.getCompletions()) != null && !completions.isEmpty()) {
            for (TaskCompletion completion : completions) {
                activities.add(this.taskCompletionMapper.buildActivity(content, state, task, completion));
            }
        }
        if ((deletionActivity = task.getDeletion()) != null) {
            activities.add(this.taskDeletionMapper.buildActivity(content, state, task));
        }
        if ((currentDueDate = task.getCurrentDueDate()) != null) {
            activities.addAll(this.generateDueDateActivities(content, state, task, currentDueDate));
        }
        if ((dueDateHistoryRecords = task.getDueDateHistory()) != null && !dueDateHistoryRecords.isEmpty()) {
            for (DueDateRecord dueDateHistoryRecord : dueDateHistoryRecords) {
                activities.addAll(this.generateDueDateActivities(content, state, task, dueDateHistoryRecord));
            }
        }
        return activities;
    }

    private List<Activity> generateDueDateActivities(AbstractPage content, PageState state, PageTask task, DueDateRecord dueDateRecord) throws WorkflowUserException {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        if (dueDateRecord.getDueDate() == null) {
            activities.add(this.taskDueDateDeletionMapper.buildActivity(content, state, task, dueDateRecord));
        } else {
            activities.add(this.taskDueDateMapper.buildActivity(content, state, task, dueDateRecord));
            if (dueDateRecord.isExpired() & dueDateRecord.isExpiryTriggered()) {
                activities.add(this.taskDueDateExpiryMapper.buildActivity(content, state, task, dueDateRecord.getDueDate().getTime()));
            }
        }
        return activities;
    }
}

