/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.StateExpiredNotification;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowsNotificationPublisher;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.event.StateExpireEvent;
import com.comalatech.workflow.model.State;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class StateNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final WorkflowAccessor workflowAccessor;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final WorkflowsNotificationPublisher workflowsNotificationPublisher;

    public StateNotificationListener(@ComponentImport EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, @ComponentImport UserAccessor userAccessor, WorkflowAccessor workflowAccessor, WorkflowConfigurationManager workflowConfigurationManager, WorkflowsNotificationPublisher workflowsNotificationPublisher) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.workflowsNotificationPublisher = workflowsNotificationPublisher;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowAccessor = workflowAccessor;
    }

    @EventListener
    public void stateExpiredEvent(StateExpireEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.STATE_EXPIRED, page.getSpaceKey())) {
            State state = event.getState();
            Permission requiredPermission = this.getConfluencePermissionRequired(page, state);
            StateExpiredNotification notification = new StateExpiredNotification();
            notification.setEntityId(event.getContent().getId());
            notification.addContextProperty("stateName", state.getName());
            notification.addContextProperty("pageTitle", page.getTitle());
            notification.addContextProperty("pagePath", page.getUrlPath());
            notification.addContextProperty("activityDescription", "com.comalatech.state.notification.expired.description");
            notification.addContextProperty("slackActivityDescription", "com.comalatech.state.notification.slack.expired.description");
            Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, null, true, null, null);
            this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
            this.adhocNotificationService.sendEmail(notification, watchers, requiredPermission, null);
        }
    }

    protected Permission getConfluencePermissionRequired(AbstractPage page, State state) {
        WorkflowVisibilityInternal visibility;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isRequiresFinalApproval() && !state.isPublished() && WorkflowVisibilityInternal.CONTRIBUTORS == (visibility = this.workflowConfigurationManager.getHistoryVisibility(page.getSpaceKey()))) {
            return Permission.EDIT;
        }
        return Permission.VIEW;
    }
}

