/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.SignatureType;
import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;

public abstract class PageActivityCsvProcessor
implements PageActivityEntryProcessor {
    protected static final String COMMA = ",";
    private PageActivityCsvConfig pageActivityCsvConfig;
    private final I18nResolver i18nResolver;

    public PageActivityCsvProcessor(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    protected void setPageActivityCsvConfig(PageActivityCsvConfig pageActivityCsvConfig) {
        this.pageActivityCsvConfig = pageActivityCsvConfig;
    }

    protected String getI18nText(String key) {
        if (this.pageActivityCsvConfig.getLocale() == null) {
            return this.i18nResolver.getText(key);
        }
        return this.i18nResolver.getText(this.pageActivityCsvConfig.getLocale(), key);
    }

    protected String getI18nText(String key, String[] args) {
        if (this.pageActivityCsvConfig.getLocale() == null) {
            return this.i18nResolver.getText(key, (Serializable[])args);
        }
        return this.i18nResolver.getText(this.pageActivityCsvConfig.getLocale(), key, (Serializable[])args);
    }

    protected boolean isSkipOtherVersion() {
        return this.pageActivityCsvConfig.isSkipOtherVersion();
    }

    protected void generateHeaders(CSVBuilder csv) {
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.date.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.username.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.contributors.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.activity.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.description.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.pageversion.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.pageId.header"));
        csv.addCell(this.getI18nText("com.comalatech.activity.report.csvexport.usercomment.header"));
        csv.newLine();
    }

    String getConfluenceSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getI18nText("com.comalatech.activity.report.approval.esig.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getI18nText("com.comalatech.activity.report.approval.esig.user");
            }
        }
        return "";
    }

    protected String getOTPSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getI18nText("com.comalatech.activity.report.approval.esig.otp.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getI18nText("com.comalatech.activity.report.approval.esig.otp.user");
            }
        }
        return "";
    }

    protected String removeCSVInjectionCharacters(String content) {
        if (content != null) {
            content = content.replaceFirst("^[\\+\\-\\@\\=]", "");
        }
        return content;
    }

    protected String cleanCSVValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.trim().length() == 0) {
            return "";
        }
        return StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(value));
    }
}

