/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="Information or error message indicating the outcome for an operation")
public class Message {
    @ApiModelProperty(value=" Type of message from Info|Error", dataType="string", example="Error")
    public String type;
    @ApiModelProperty(value="Message title", dataType="string", example="Credentials required")
    public String title;
    @ApiModelProperty(value="Value in html to show to the user", dataType="string", example="Valid user/password are required to process the approval")
    public String html;
    @ApiModelProperty(value="If the message is dismissible", dataType="boolean", example="true")
    public boolean closeable;
    @ApiModelProperty(value="Code", dataType="string")
    public String code;

    public Message() {
    }

    public Message(String type, String title, String html, boolean closeable) {
        this.type = type;
        this.title = title;
        this.html = html;
        this.closeable = closeable;
        this.code = MessageCode.CUSTOM.toString();
    }

    public Message(String type, String title, String html, boolean closeable, MessageCode code) {
        this.type = type;
        this.title = title;
        this.html = html;
        this.closeable = closeable;
        this.code = code.toString();
    }

    public static enum MessageCode {
        INVALID_CREDENTIALS,
        INVALID_PARAMETERS,
        CUSTOM;

    }

    public static enum MessageType {
        ERROR,
        WARNING,
        SUCCESS,
        INFO,
        HINT,
        GENERIC;

    }
}

