/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.expander.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.rest.expander.content.AbstractWorkflowActionExpander;
import com.comalatech.confluence.workflow.rest.model.ContentTask;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowRequest;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.model.Assignment;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TasksExpander
extends AbstractWorkflowActionExpander {
    public static final String EXPANDER = "tasks";
    private final TaskService taskService;
    private final UserSearchManager userSearchManager;

    public TasksExpander(TaskService taskService, UserSearchManager userSearchManager) {
        super(EXPANDER);
        this.taskService = taskService;
        this.userSearchManager = userSearchManager;
    }

    @Override
    public void expand(ContentWorkflowResponse response, ContentWorkflowRequest request) {
        ArrayList<ContentTask> tasks = new ArrayList<ContentTask>();
        List<com.comalatech.workflow.model.ContentTask> contentTasks = this.taskService.getTasks((ContentEntityObject)request.getPage());
        boolean addContributors = false;
        for (com.comalatech.workflow.model.ContentTask contentTask : contentTasks) {
            ContentTask task = this.makeTask(contentTask, request.isAdmin());
            if (task.actions.contains("assign")) {
                addContributors = true;
            }
            tasks.add(task);
        }
        response.tasks = tasks;
        if (request.getWorkflowAction().getContributors().results.size() == 0) {
            request.getWorkflowAction().setContributors(this.userSearchManager.getContributors(request.getPage(), addContributors));
        }
    }

    private ContentTask makeTask(com.comalatech.workflow.model.ContentTask contentTask, boolean admin) {
        Assignment lastAssignment = contentTask.getTask().getLastAssignment();
        ContentTask task = new ContentTask(contentTask.getTask().getActivityId(), contentTask.getTask().getName());
        if (contentTask.getTask().isCompleted()) {
            task.date = contentTask.getTask().getLastCompletion().getDate().getTime();
            task.comment = contentTask.getTask().getLastCompletion().getComment();
        } else {
            String assignee = null;
            if (lastAssignment != null && StringUtils.isNotBlank((CharSequence)lastAssignment.getAssignee())) {
                task.assignee = this.userSearchManager.makeUser(lastAssignment.getAssignee());
                task.comment = lastAssignment.getComment();
            }
            if (contentTask.getTask().canComplete()) {
                task.actions.add("assign");
                task.actions.add("complete");
            }
            if (admin || assignee != null && assignee.equals(AuthenticatedUserThreadLocal.getUsername())) {
                task.actions.add("delete");
            }
            if (contentTask.getTask().getDueDate() != null) {
                task.dueDate = contentTask.getTask().getDueDate().getTime();
            }
        }
        return task;
    }
}

