/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.k15t.airbus;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.listeners.ApprovalPersistanceHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifiedParentFromK15TListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(NotifiedParentFromK15TListener.class);
    private static final String K15T_EVENT_EMITTER = "com.k15t.child.notifying.update.to.parent";
    private final PageManager pageManager;
    private final ApprovalPersistanceHandler approvalPersistanceHandler;

    public NotifiedParentFromK15TListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, @ComponentImport PageManager pageManager, ApprovalPersistanceHandler approvalPersistanceHandler, EventHistoryManager eventHistoryManager, @ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport EventPublisher eventPublisher) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.pageManager = pageManager;
        this.approvalPersistanceHandler = approvalPersistanceHandler;
    }

    @EventListener
    public void handleChildUpdateNotifiedToParentAsAParentUpdate(Properties properties) {
        if (K15T_EVENT_EMITTER.equals(properties.getProperty("emitter"))) {
            this.handleChildUpdateNotifiedEvent(properties);
        }
    }

    private void handleChildUpdateNotifiedEvent(Properties properties) {
        String parentPageIdToUpdate = properties.getProperty("parentPageIdToUpdate");
        if (Objects.isNull(parentPageIdToUpdate)) {
            log.warn("There was a k15t event without a parent page id to update.");
            return;
        }
        AbstractPage page = this.pageManager.getAbstractPage(Long.parseLong(parentPageIdToUpdate));
        if (Objects.isNull(page)) {
            log.warn("The given page id (" + parentPageIdToUpdate + ") doesn't exist ");
            return;
        }
        this.generatePageUpdateEvent((Page)page);
    }

    private void generatePageUpdateEvent(Page page) {
        PageUpdateEvent pageUpdateEvent = new PageUpdateEvent((Object)this, page, null, false, PageUpdateTrigger.EDIT_PAGE);
        PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)pageUpdateEvent);
        if (Objects.isNull(pageWorkflows)) {
            log.warn("The given page doesn't have a workflow attached.");
            return;
        }
        this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)pageUpdateEvent);
        this.approvalPersistanceHandler.handle(pageUpdateEvent);
    }
}

