/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.dao.PageStateDao;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DeletionActivity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ParameterResolver;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.StateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultStateAccessor
implements StateAccessor,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultStateAccessor.class);
    private ApplicationContext applicationContext;
    private final PageStateDao pageStateDao;
    private WorkflowAccessor workflowAccessor;
    private ParameterResolver parameterResolver;
    private StateService stateService;
    private DocumentActivityUpgradeService documentActivityUpgradeService;
    private ApprovalAccessor approvalAccessor;
    private final DarkFeatureManager darkFeatureManager;

    public DefaultStateAccessor(PageStateDao pageStateDao, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.pageStateDao = pageStateDao;
        this.darkFeatureManager = darkFeatureManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.workflowAccessor = (WorkflowAccessor)this.applicationContext.getBean(WorkflowAccessor.class);
        this.parameterResolver = (ParameterResolver)this.applicationContext.getBean(ParameterResolver.class);
        this.stateService = (StateService)this.applicationContext.getBean(StateService.class);
        this.documentActivityUpgradeService = (DocumentActivityUpgradeService)this.applicationContext.getBean(DocumentActivityUpgradeService.class);
        this.approvalAccessor = (ApprovalAccessor)this.applicationContext.getBean(ApprovalAccessor.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public PageState getLatestState(AbstractPage abstractPage) {
        PageState state = this.pageStateDao.getLatestPageState(abstractPage);
        if (state == null) {
            List<PageState> allStates = this.getPageStates(abstractPage);
            if (allStates != null && !allStates.isEmpty()) {
                state = allStates.get(allStates.size() - 1);
            }
            if (state != null) {
                this.pageStateDao.setLatestPageState(abstractPage, state);
            }
        }
        if (state != null) {
            state.setPage(abstractPage);
        }
        return state;
    }

    @Override
    public PageState getLatestFinalState(AbstractPage page) {
        return this.pageStateDao.getLatestFinalPageState(page);
    }

    @Override
    public void setLatestFinalState(AbstractPage page, PageState state) {
        this.pageStateDao.setLatestFinalPageState(page, state);
    }

    @Override
    public void setPageStates(AbstractPage abstractPage, List<PageState> pageStates) {
        this.documentActivityUpgradeService.isSpaceStatusUpgradeSuccess(abstractPage);
        this.pageStateDao.setPageStates(abstractPage, pageStates);
    }

    private void updatePageState(AbstractPage page, PageState state) {
        List<PageState> states = this.getPageStates(page);
        if (!states.isEmpty()) {
            states.remove(states.size() - 1);
        }
        states.add(state);
        this.setPageStates(page, states);
    }

    @Override
    public List<PageState> getPageStates(AbstractPage page) {
        List<PageState> states = this.pageStateDao.getPageStates(page);
        if (states == null) {
            states = new ArrayList<PageState>();
        }
        return states;
    }

    @Override
    public PageState changeState(AbstractPage page, PageState pageState, boolean moveOpenTasks) {
        State workflowPageState;
        boolean isCurrentAndTargetStatesFinal;
        if (!page.isLatestVersion()) {
            throw new RuntimeException("can only set state on the latest version of page " + page);
        }
        PageState currentState = this.getLatestState(page);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (currentState != null && pageWorkflows != null) {
            currentState = pageWorkflows.getEnrichedPageState(currentState);
        }
        boolean bl = isCurrentAndTargetStatesFinal = currentState != null && currentState.isPublished() && pageState.isPublished();
        if (currentState != null && currentState.matchesState(pageState) && !isCurrentAndTargetStatesFinal) {
            return currentState;
        }
        int id = currentState == null ? 1 : currentState.getId() + 1;
        pageState.setId(id);
        if (currentState != null && moveOpenTasks) {
            this.moveOpenTasks(currentState, pageState);
        }
        List<PageState> states = this.getPageStates(page);
        states.add(pageState);
        this.setPageStates(page, states);
        if (pageWorkflows != null && pageWorkflows.getStatesContainer() != null && (workflowPageState = pageWorkflows.getStatesContainer().getState(pageState)) != null && workflowPageState.isFinalState() && !this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true).booleanValue()) {
            this.approvalAccessor.saveApprovalChecksBeforeLastFinalState(page);
        }
        this.setupPredefinedTaskDueDates(page, pageState);
        return currentState;
    }

    @Override
    public PageState changeExpiryDate(AbstractPage page, Date expirationDate) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        PageState latest = this.getLatestState(page);
        if (latest == null && pageWorkflows != null) {
            this.forceCreateInitialState(page, pageWorkflows);
            latest = this.getLatestState(page);
        }
        if (latest != null) {
            latest.updateExpirationDate(expirationDate, WorkflowAuthenticatedUserThreadLocal.getUsername());
            this.updatePageState(page, latest);
        }
        return pageWorkflows == null ? latest : pageWorkflows.getEnrichedPageState(latest);
    }

    private void forceCreateInitialState(AbstractPage page, PageWorkflows pageWorkflows) {
        try {
            this.stateService.setState((ContentEntityObject)page, pageWorkflows.getStatesContainer().getInitialState().getName(), "Initializing state for the first time");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setupPredefinedTaskDueDates(AbstractPage page, PageState newState) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        State state = pageWorkflows.getState(newState.getName());
        if (state != null) {
            state.getTasks().forEach(task -> {
                Timer taskTimerDueDate = task.getDueDateTimer();
                if (taskTimerDueDate != null) {
                    Date expiryDate = taskTimerDueDate.getDueDate(this.parameterResolver, page);
                    PageTask pageTask = newState.getPageTasks().getByName(task.getName());
                    pageTask.setCurrentDueDate(new DueDateRecord(expiryDate, WorkflowAuthenticatedUserThreadLocal.getUsername(), new Date()));
                    this.updateTask(page, pageTask);
                }
            });
        }
    }

    private void moveOpenTasks(PageState currentState, PageState newState) {
        List<PageTask> openTasks = currentState.getPageTasks().getActiveTasks();
        for (PageTask task : openTasks) {
            PageTask newTask = new PageTask(task.getPerformer(), task.getName(), task.getType(), newState.getDate(), task.getComment());
            com.comalatech.workflow.model.Assignment assignment = task.getLastAssignment();
            if (assignment != null) {
                Assignment newAssignment = new Assignment(((Activity)((Object)assignment)).getPerformer(), newState.getDate(), ((Assignment)assignment).getAssignee(), null, ((Assignment)assignment).getGroups(), ((Assignment)assignment).getDueDate());
                newAssignment.setComment(((Activity)((Object)assignment)).getComment());
                newTask.addAssignment(newAssignment);
            }
            newTask.setCurrentDueDate(task.getCurrentDueDate());
            newState.getPageTasks().add(newTask);
        }
    }

    @Override
    public PageState getState(AbstractPage page, int id) {
        PageState state;
        List<PageState> states = this.getPageStates(page);
        if (id <= 0 || id >= states.size()) {
            return null;
        }
        if (!this.darkFeatureManager.isEnabledForAllUsers("com.comalatech.workflow.getstate.missing.duplicated.states.fix").orElse(false).booleanValue()) {
            state = states.get(id - 1);
            if (state.getId() != id) {
                throw new RuntimeException("Invalid state id in record: " + state.getId() + " but it should be " + id);
            }
        } else {
            ArrayList<Integer> duplicates;
            List<Integer> stateIds = states.stream().map(PageState::getId).collect(Collectors.toList());
            Integer firstIdOutOfSequence = this.findIdOutOfSequence(stateIds);
            if (firstIdOutOfSequence != null) {
                log.warn("Id: " + firstIdOutOfSequence + " is out of sequence in the states xml [" + stateIds + "].");
            }
            if ((state = this.findStateAndDuplicates(states, id, duplicates = new ArrayList<Integer>())) == null) {
                throw new RuntimeException("State id " + id + " not found in the states list.");
            }
            if (!duplicates.isEmpty()) {
                throw new RuntimeException("Duplicated state ids (" + duplicates + ") were present in the states list.");
            }
            ApprovalCheck checkReferringToMissingState = this.findApprovalCheckReferringToMissingState(page, states);
            if (checkReferringToMissingState != null) {
                throw new RuntimeException("ApprovalCheck: " + checkReferringToMissingState.getId() + " refers to state id: " + checkReferringToMissingState.getStateId() + " but this state is not present in the states list ");
            }
        }
        return state;
    }

    private Integer findIdOutOfSequence(List<Integer> states) {
        for (int index = 1; index <= states.size(); ++index) {
            int id = states.get(index - 1);
            if (id == index) continue;
            return id;
        }
        return null;
    }

    private PageState findStateAndDuplicates(List<PageState> states, int id, List<Integer> duplicates) {
        ArrayList stateIdList = new ArrayList();
        AtomicReference foundState = new AtomicReference();
        states.forEach(state -> {
            if (state.getId() == id) {
                foundState.set(state);
            }
            if (stateIdList.contains(state.getId())) {
                duplicates.add(state.getId());
            }
            stateIdList.add(state.getId());
        });
        return (PageState)foundState.get();
    }

    private ApprovalCheck findApprovalCheckReferringToMissingState(AbstractPage page, List<PageState> states) {
        List<ApprovalCheck> approvalChecks = Arrays.asList(this.approvalAccessor.getApprovalChecks(page));
        return approvalChecks.stream().filter(approvalCheck -> states.stream().filter(state -> state.getId() == approvalCheck.getStateId()).findFirst().orElse(null) == null).findFirst().orElse(null);
    }

    @Override
    public void updateTask(AbstractPage page, PageTask task) {
        PageState latest = this.getLatestState(page);
        if (latest == null) {
            return;
        }
        latest.getPageTasks().update(task);
        this.updatePageState(page, latest);
    }

    @Override
    public PageTask removeTask(AbstractPage page, PageTask task, String comment) {
        PageState latest = this.getLatestState(page);
        if (latest == null) {
            return null;
        }
        PageTask pageTask = latest.getPageTasks().getById(task.getId());
        latest.getPageTasks().remove(task.getId());
        DeletionActivity deletionActivity = new DeletionActivity(AuthenticatedUserThreadLocal.getUsername(), new Date());
        deletionActivity.setComment(comment);
        pageTask.setDeletion(deletionActivity);
        latest.getPageTasks().addDeletedTask(pageTask);
        this.updatePageState(page, latest);
        return pageTask;
    }

    @Override
    public void updateTimer(AbstractPage page, PageStateTimer timer) {
        PageState latest = this.getLatestState(page);
        if (latest == null) {
            return;
        }
        latest.replaceTimer(timer);
        this.updatePageState(page, latest);
    }

    @Override
    public void addTask(AbstractPage page, PageTask task) {
        PageState latest = this.getLatestState(page);
        if (latest == null) {
            log.warn("there is no page state on " + page + ". cannot add task");
            return;
        }
        latest.getPageTasks().add(task);
        this.updatePageState(page, latest);
    }

    @Override
    public void removeStates(AbstractPage page) {
        this.pageStateDao.removePageStates(page);
    }

    @Override
    public PageState getPreviousStateToFinalState(AbstractPage content, PageState publishedState) {
        PageState previousState = null;
        if (publishedState != null) {
            int publishedStateId = publishedState.getId();
            List<PageState> states = this.getPageStates(content);
            if (states != null && !states.isEmpty()) {
                previousState = states.stream().filter(state -> state.getId() == publishedStateId - 1).findFirst().orElse(null);
            }
        }
        return previousState;
    }
}

