/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.services;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActions.mappers.DocumentActionsMapper;
import com.comalatech.confluence.documentActions.mappers.PendingApprovalsMapper;
import com.comalatech.confluence.documentActions.mappers.TasksMapper;
import com.comalatech.confluence.documentActions.services.DocumentActionsService;
import com.comalatech.confluence.documentActions.services.model.ActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.DocumentActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.search.SearchQuery;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.workflow.StateService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentActionsServiceImpl
implements DocumentActionsService {
    private static final Logger log = LoggerFactory.getLogger(DocumentActionsServiceImpl.class);
    private final List<DocumentActionsMapper> mappers;

    public DocumentActionsServiceImpl(ApprovalAccessor approvalAccessor, @ComponentImport PageManager pageManager, StateService stateService, @ComponentImport UserAccessor userAccessor, @ComponentImport BootstrapManager bootstrapManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean) {
        ObjectMapper jsonMapper = new ObjectMapper();
        this.mappers = new ArrayList<DocumentActionsMapper>();
        this.mappers.add(new PendingApprovalsMapper(jsonMapper, approvalAccessor, pageManager, stateService, userAccessor));
        this.mappers.add(new TasksMapper(jsonMapper, pageManager, userAccessor, bootstrapManager, workflowsFeatureManager, comalaI18nBean));
    }

    @Override
    public SearchQuery buildSearchQuery(int start, int limit, String sortingFields, String sortingOrder, String type) {
        String userKey = AuthenticatedUserThreadLocal.get().getKey().getStringValue();
        SearchQuery.Builder searchBuilder = new SearchQuery.Builder().withStart(start).withPageLimit(limit).withSortingFields(sortingFields).withSortingOrder(sortingOrder).withTypes(type).withUserkey(userKey);
        return searchBuilder.build();
    }

    @Override
    public DocumentActionsSearchResult buildDocumentActionsSearchResultFrom(SearchPageResponse<SearchResult> searchResults) {
        return this.buildDocumentActionsSearchResultFrom(searchResults, AuthenticatedUserThreadLocal.get());
    }

    public DocumentActionsSearchResult buildDocumentActionsSearchResultFrom(SearchPageResponse<SearchResult> searchResults, ConfluenceUser user) {
        DocumentActionsSearchResult documentResult = this.initializeDocumentReport(searchResults);
        for (SearchResult result : searchResults) {
            Content contentEntity = (Content)result.getEntity();
            Map metadataProperties = (Map)contentEntity.getMetadata().get("properties");
            ActionsSearchResult actionsSearchResult = new ActionsSearchResult();
            this.applyJsonMappers(this.mappers, user, contentEntity, metadataProperties, actionsSearchResult);
            documentResult.getActionsSearchResults().add(actionsSearchResult);
        }
        return documentResult;
    }

    private void applyJsonMappers(List<DocumentActionsMapper> mappers, ConfluenceUser currentUser, Content contentEntity, Map<String, JsonContentProperty> metadataProperties, ActionsSearchResult actionsSearchResult) {
        if (Objects.isNull(metadataProperties)) {
            log.warn("the metadataProperties parameter should contain values but it's null.");
            return;
        }
        for (Map.Entry<String, JsonContentProperty> propertyNamePropertyDataEntry : metadataProperties.entrySet()) {
            mappers.forEach(mapper -> mapper.map(actionsSearchResult, currentUser, contentEntity, propertyNamePropertyDataEntry));
        }
    }

    private DocumentActionsSearchResult initializeDocumentReport(SearchPageResponse<SearchResult> searchResults) {
        DocumentActionsSearchResult documentActionsResult = new DocumentActionsSearchResult();
        documentActionsResult.setStart(searchResults.getPageRequest().getStart());
        documentActionsResult.setLimit(searchResults.getPageRequest().getLimit());
        documentActionsResult.setSize(searchResults.size());
        documentActionsResult.setTotalSize(searchResults.totalSize());
        return documentActionsResult;
    }
}

