/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.resources;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.dataextractor.resources.AbstractDataExtractorResource;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.esignatures.resources.model.RestPopulationJob;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/dataextractor/space/")
public class DataExtractorResource
extends AbstractDataExtractorResource {
    private final DataExtractorManager dataExtractorManager;

    @Inject
    public DataExtractorResource() {
        this.dataExtractorManager = PluginContainerManager.getComponent(DataExtractorManager.class);
    }

    @Autowired
    public DataExtractorResource(@ComponentImport PermissionManager permissionManager, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport SpaceManager spaceManager, DataExtractorManager dataExtractorManager) {
        super(permissionManager, workflowsFeatureManager, spaceManager);
        this.dataExtractorManager = dataExtractorManager;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/{spaceKey}/populate")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Long running task started"), @ApiResponse(code=403, message="User is not administrator"), @ApiResponse(code=400, message="Space key is null or does not exists"), @ApiResponse(code=500, message="Error starting the job")})
    public Response startSpacePropertiesPopulationJob(@PathParam(value="spaceKey") String spaceKey) {
        final Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return new AbstractDataExtractorResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                LongRunningTaskId longRunningTaskId = DataExtractorResource.this.dataExtractorManager.launchPopulatorTaskForSpace(space);
                return DataExtractorResource.this.buildRestDataExtractorPopulationJobResponse(longRunningTaskId.toString());
            }
        }.execute();
    }

    protected Response buildRestDataExtractorPopulationJobResponse(String jobId) {
        RestPopulationJob restPopulationJob = new RestPopulationJob(jobId);
        return Response.ok().entity((Object)restPopulationJob).type("application/json").build();
    }
}

