/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.CloudMarkup;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.WorkflowMarkups;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.WorkflowMigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.MigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.translator.application.ServerWorkflowCommand;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.workflow.WorkflowParameterManager;
import com.comalatech.workflow.model.WorkflowParameter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="spaceWorkflowMigrationProcessor")
public class SpaceWorkflowMigrationProcessor
implements MigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowMigrationProcessor.class);
    private static final String SPACE_WORKFLOW_MIGRATION_VERSION = "1";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private final SystemInformationService systemInformationService;
    private final WorkflowService workflowService;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowTranslator workflowTranslator;
    private final UserAccessor userAccessor;
    private final CloudMappingsData cloudMappingsData;
    private final CloudPopulationData<String> userPopulationData;
    private final CloudPopulationData<String> groupPopulationData;
    private final WorkflowParameterManager workflowParameterManager;

    public SpaceWorkflowMigrationProcessor(@ComponentImport SystemInformationService systemInformationService, WorkflowService workflowService, WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator, @ComponentImport UserAccessor userAccessor, CloudMappingsData cloudMappingsData, @Qualifier(value="cloudWorkflowUserIdPopulationUseCase") CloudPopulationData<String> userPopulationData, @Qualifier(value="cloudWorkflowGroupIdPopulationUseCase") CloudPopulationData<String> groupPopulationData, WorkflowParameterManager workflowParameterManager) {
        this.systemInformationService = systemInformationService;
        this.workflowService = workflowService;
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowTranslator = workflowTranslator;
        this.userAccessor = userAccessor;
        this.cloudMappingsData = cloudMappingsData;
        this.userPopulationData = userPopulationData;
        this.groupPopulationData = groupPopulationData;
        this.workflowParameterManager = workflowParameterManager;
    }

    @Override
    public Migration process(AppCloudMigrationGateway gateway, List<String> spaceKeys, String transferId, MigrationDetailsV1 migrationDetailsV1) throws Exception {
        Migration cloudMigration = new Migration();
        spaceKeys.forEach(spaceKey -> {
            List<com.comalatech.workflow.model.Workflow> workflowList = this.workflowService.getWorkflows((String)spaceKey);
            if (!workflowList.isEmpty()) {
                List<WorkflowParameter> workflowParameters = this.workflowParameterManager.getSpaceWorkflowsParameters((String)spaceKey);
                WorkflowMigrationEntity migrationEntity = new WorkflowMigrationEntity();
                migrationEntity.setSpaceKey((String)spaceKey);
                migrationEntity.setWorkflows(new ArrayList<WorkflowMarkups>());
                workflowList.forEach(workflow -> {
                    String finalCloudWorkflowMarkup;
                    String cloudWorkflowMarkup = this.getCloudWorkflowMarkup((com.comalatech.workflow.model.Workflow)workflow);
                    try {
                        finalCloudWorkflowMarkup = this.manageParseCloudID(cloudWorkflowMarkup, gateway, transferId);
                    }
                    catch (Exception e) {
                        log.error("Error processing cloud json: {}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                    migrationEntity.getWorkflows().add(WorkflowMarkups.builder().cloudMarkup(CloudMarkup.builder().parameters(this.getFilterParameters((com.comalatech.workflow.model.Workflow)workflow, workflowParameters)).workflow(finalCloudWorkflowMarkup).build()).serverMarkup(workflow.getWorkflowMarkup()).isActive(workflow.isActive()).build());
                });
                cloudMigration.migrationEntities.add(migrationEntity);
            }
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = SPACE_WORKFLOW_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.SPACE_WORKFLOW.getLabel();
        return cloudMigration;
    }

    @Override
    public Migration debug(List<String> spaceKeys) throws Exception {
        Migration cloudMigration = new Migration();
        for (String spaceKey : spaceKeys) {
            List<com.comalatech.workflow.model.Workflow> workflowList = this.workflowService.getWorkflows(spaceKey);
            if (workflowList.isEmpty()) continue;
            cloudMigration.migrationEntities.addAll(this.generateMigrationEntitiesList(spaceKey, workflowList));
        }
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = SPACE_WORKFLOW_MIGRATION_VERSION;
        return cloudMigration;
    }

    @Override
    public Migration debug(AbstractPage content) throws Exception {
        return this.getMigrationServer(content.getSpaceKey());
    }

    private String manageParseCloudID(String cloudWorkflowMarkup, AppCloudMigrationGateway gateway, String transferId) throws JsonProcessingException {
        JsonNode triggersNode;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        HashSet<String> groupID = new HashSet<String>();
        HashSet<String> usersID = new HashSet<String>();
        JsonNode rootNode = objectMapper.readTree(cloudWorkflowMarkup);
        this.extractParameters(rootNode, usersID, groupID);
        JsonNode statesNode = rootNode.get("states");
        if (!Objects.isNull(statesNode) && statesNode.isArray()) {
            statesNode.forEach(stateNode -> this.extractApprovals((JsonNode)stateNode, usersID, groupID));
        }
        if (!Objects.isNull(triggersNode = rootNode.get("triggers")) && triggersNode.isArray()) {
            triggersNode.forEach(triggerNode -> this.extractActions((JsonNode)triggerNode, usersID, groupID));
        }
        Map<String, String> userMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.USERS_KEY.toString(), usersID);
        Map<String, String> groupMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_GROUP.toString(), groupID);
        cloudWorkflowMarkup = this.userPopulationData.populateCloudData(cloudWorkflowMarkup, userMapping);
        cloudWorkflowMarkup = this.groupPopulationData.populateCloudData(cloudWorkflowMarkup, groupMapping);
        return cloudWorkflowMarkup;
    }

    private void extractActions(JsonNode triggerNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode actions = triggerNode.get("actions");
        if (Objects.isNull(actions) || !actions.isArray()) {
            return;
        }
        actions.forEach(actionNode -> {
            JsonNode userOrGroupRestrictions;
            JsonNode recipients;
            if (actionNode.get("action").asText().equals("send-email") && Objects.nonNull(recipients = actionNode.get("recipients"))) {
                for (JsonNode recipient : recipients) {
                    ConfluenceUser user;
                    if (Objects.nonNull(recipient.get(USER)) && !recipient.get(USER).asText().contains("@") && Objects.nonNull(user = this.userAccessor.getUserByName(recipient.get(USER).asText()))) {
                        usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                    }
                    if (!Objects.nonNull(recipient.get(GROUP)) || recipient.get(GROUP).asText().contains("@")) continue;
                    groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + recipient.get(GROUP).asText());
                }
            }
            if ((actionNode.get("action").asText().equals("set-restrictions") || actionNode.get("action").asText().equals("add-restrictions")) && Objects.nonNull(userOrGroupRestrictions = actionNode.get("restrictions"))) {
                for (JsonNode userOrGroupRestriction : userOrGroupRestrictions) {
                    String restriction;
                    if (Objects.nonNull(userOrGroupRestriction.get(USER))) {
                        ArrayNode userRestrictions = (ArrayNode)userOrGroupRestriction.get(USER);
                        for (JsonNode userRestriction : userRestrictions) {
                            ConfluenceUser user;
                            restriction = userRestriction.asText();
                            if (!Objects.nonNull(restriction) || restriction.contains("@") || !Objects.nonNull(user = this.userAccessor.getUserByName(restriction))) continue;
                            usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                        }
                    }
                    if (!Objects.nonNull(userOrGroupRestriction.get(GROUP))) continue;
                    ArrayNode groupRestrictions = (ArrayNode)userOrGroupRestriction.get(GROUP);
                    for (JsonNode groupRestriction : groupRestrictions) {
                        restriction = groupRestriction.asText();
                        if (!Objects.nonNull(restriction) || restriction.contains("@")) continue;
                        groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + restriction);
                    }
                }
            }
        });
    }

    private void extractApprovals(JsonNode stateNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode approvals = stateNode.get("approvals");
        if (Objects.isNull(approvals) || !approvals.isArray()) {
            return;
        }
        approvals.forEach(approvalNode -> {
            JsonNode preassignedGroups;
            JsonNode preassignedUsers;
            JsonNode jsonNode = preassignedUsers = Objects.nonNull(approvalNode.get("preassignedUsers")) ? approvalNode.get("preassignedUsers").get("items") : null;
            if (Objects.nonNull(preassignedUsers) && preassignedUsers.isArray()) {
                for (JsonNode preassignedUser : preassignedUsers) {
                    ConfluenceUser user;
                    if (preassignedUser.asText().contains("@") || !Objects.nonNull(user = this.userAccessor.getUserByName(preassignedUser.asText()))) continue;
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                }
            }
            JsonNode jsonNode2 = preassignedGroups = Objects.nonNull(approvalNode.get("preassignedGroups")) ? approvalNode.get("preassignedGroups").get("items") : null;
            if (Objects.nonNull(preassignedGroups) && preassignedGroups.isArray()) {
                for (JsonNode preassignedGroup : preassignedGroups) {
                    if (preassignedGroup.asText().contains("@")) continue;
                    groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + preassignedGroup.asText());
                }
            }
        });
    }

    private void extractParameters(JsonNode rootNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode parameters = rootNode.get("parameters");
        if (Objects.isNull(parameters) || !parameters.isArray()) {
            return;
        }
        for (JsonNode parameter : parameters) {
            JsonNode value = parameter.get("value");
            if (value == null || value.asText().contains("@")) continue;
            if (parameter.get("type").asText().equals(USER)) {
                ConfluenceUser user = this.userAccessor.getUserByName(value.asText());
                if (!Objects.nonNull(user)) continue;
                usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                continue;
            }
            if (!parameter.get("type").asText().equals(GROUP)) continue;
            groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + value.asText());
        }
    }

    private String getCloudWorkflowMarkup(com.comalatech.workflow.model.Workflow workflow) {
        String jsonWorkflowString = this.workflowMarkupManager.convertToJson((Workflow)workflow);
        return new JSONObject(this.workflowTranslator.handle(ServerWorkflowCommand.builder().workflow(new JSONObject(jsonWorkflowString).toMap()).build())).get("workflow").toString();
    }

    private Migration getMigrationServer(String spaceKey) {
        List<com.comalatech.workflow.model.Workflow> workflowList = this.workflowService.getWorkflows(spaceKey);
        if (workflowList.isEmpty()) {
            return null;
        }
        Migration cloudMigration = new Migration(this.generateMigrationEntitiesList(spaceKey, workflowList));
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = SPACE_WORKFLOW_MIGRATION_VERSION;
        return cloudMigration;
    }

    private List<MigrationEntity> generateMigrationEntitiesList(String spaceKey, List<com.comalatech.workflow.model.Workflow> workflowList) {
        ArrayList<MigrationEntity> migrationEntitiesList = new ArrayList<MigrationEntity>();
        WorkflowMigrationEntity migrationEntity = new WorkflowMigrationEntity();
        migrationEntity.setSpaceKey(spaceKey);
        migrationEntity.setWorkflows(new ArrayList<WorkflowMarkups>());
        List<WorkflowParameter> workflowParameters = this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey);
        workflowList.forEach(workflow -> migrationEntity.getWorkflows().add(WorkflowMarkups.builder().cloudMarkup(CloudMarkup.builder().parameters(this.getFilterParameters((com.comalatech.workflow.model.Workflow)workflow, workflowParameters)).workflow(this.getCloudWorkflowMarkup((com.comalatech.workflow.model.Workflow)workflow)).build()).serverMarkup(workflow.getWorkflowMarkup()).isActive(workflow.isActive()).build()));
        migrationEntitiesList.add(migrationEntity);
        return migrationEntitiesList;
    }

    private Map<String, String> getFilterParameters(com.comalatech.workflow.model.Workflow workflow, List<WorkflowParameter> workflowParameters) {
        Map<String, String> workflowParameterList = workflow.getWorkflowParameters().stream().collect(Collectors.toMap(WorkflowParameter::getName, WorkflowParameter::getValue));
        return workflowParameters.stream().filter(workflowParameter -> workflowParameterList.containsKey(workflowParameter.getName()) && !((String)workflowParameterList.get(workflowParameter.getName())).equals(workflowParameter.getValue())).collect(Collectors.toMap(WorkflowParameter::getName, WorkflowParameter::getValue));
    }
}

