/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudPageActivityContentIdPopulationUseCase")
public class CloudPageActivityContentIdPopulationUseCase
implements CloudPopulationData<State> {
    private static final Logger log = LoggerFactory.getLogger(CloudPageActivityContentIdPopulationUseCase.class);

    @Override
    public State populateCloudData(State state, Map<String, String> contentMapping) {
        String serverContentId = state.getContentId();
        if (serverContentId == null) {
            log.error("There is no content id for the state {}", (Object)state.getName());
            return state;
        }
        if (contentMapping.containsKey(serverContentId)) {
            state.setContentId(contentMapping.get(serverContentId));
        } else {
            log.error("There is not any cloud mapping id for the server content id {}", (Object)serverContentId);
        }
        return state;
    }
}

