/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.supplier;

import org.randombits.confluence.supplier.Supplier;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSupplier<T>
implements Supplier {
    private Class<T> type;
    private boolean prefixRequired;
    private String[] prefixes;

    public SimpleSupplier(Class<T> type, boolean prefixRequired, String ... prefixes) {
        this.type = type;
        this.prefixRequired = prefixRequired;
        this.prefixes = new String[prefixes.length];
        System.arraycopy(prefixes, 0, this.prefixes, 0, prefixes.length);
    }

    protected Class<T> getType() {
        return this.type;
    }

    @Override
    public Object getValue(Object context, String key) throws UnsupportedContextException, SupplierException {
        if (this.type.isInstance(context)) {
            return this.findValue(this.type.cast(context), key);
        }
        throw new UnsupportedContextException(context);
    }

    protected abstract Object findValue(T var1, String var2) throws SupplierException;

    @Override
    public boolean supportsContext(Object context) {
        return this.type.isInstance(context);
    }

    @Override
    public boolean supportsPrefix(String prefix) {
        if (prefix == null) {
            return !this.prefixRequired;
        }
        for (String p : this.prefixes) {
            if (!p.equals(prefix)) continue;
            return true;
        }
        return false;
    }
}

