/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import com.comalatech.confluence.service.ClearWorkflowHistoryService;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowHistoryClearedEventImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@ReadOnlyAccessBlocked
@WebSudoRequired
public class ClearWorkflowHistoryAction
extends AbstractSpaceAction
implements SpaceAware {
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private TransactionalHostContextAccessor transactionalHostContextAccessor;
    @ComponentImport
    private LongRunningTaskManager longRunningTaskManager;
    @ComponentImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private AccessModeService accessModeService;
    private ClearWorkflowHistoryService clearWorkflowHistoryService;
    private LongRunningTaskId longRunningTaskId;
    public static final int BATCH_SIZE = 100;
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/spaceclearhistory/6JjR6Q";

    public String clearWorkflowHistory() {
        return "success";
    }

    public String doClearWorkflowHistory() {
        ClearWorkflowHistoryTask task = new ClearWorkflowHistoryTask();
        this.longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)this.getAuthenticatedUser(), (LongRunningTask)task);
        SpaceWorkflowHistoryClearedEventImpl event = new SpaceWorkflowHistoryClearedEventImpl(this.space);
        this.eventPublisher.publish((Object)event);
        return "success";
    }

    public void setClearWorkflowHistoryService(ClearWorkflowHistoryService clearWorkflowHistoryService) {
        this.clearWorkflowHistoryService = clearWorkflowHistoryService;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setTransactionalHostContextAccessor(TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
    }

    private List<AbstractPage> getAllPages(String spaceKey) {
        ArrayList<AbstractPage> pagesAndBlogs = new ArrayList<AbstractPage>();
        if (spaceKey != null) {
            List pages = this.pageManager.getPages(this.space, true);
            List blogs = this.pageManager.getBlogPosts(this.space, true);
            pagesAndBlogs.addAll(pages);
            pagesAndBlogs.addAll(blogs);
        }
        return pagesAndBlogs;
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isPermitted() {
        return super.isPermitted() && (this.isConfluenceAdministrator() || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.space));
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public String getTaskId() {
        return this.longRunningTaskId.toString();
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }

    public class ClearWorkflowHistoryTask
    extends ConfluenceAbstractLongRunningTask {
        private String errorMessage = null;
        private String userName = AuthenticatedUserThreadLocal.getUsername();
        private int updated = 0;
        private int errors = 0;
        private int totalValidationErrors = 0;
        private int maxErrorsAllowed = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInternal() {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            ConfluenceUser user = ClearWorkflowHistoryAction.this.userAccessor.getUserByName(this.userName);
            try {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                List<Long> pagesAndBlogs = this.getPagesToInitialise(ClearWorkflowHistoryAction.this.getSpaceKey());
                int totalBatches = pagesAndBlogs.size() / 100;
                totalBatches += pagesAndBlogs.size() % 100 > 0 ? 1 : 0;
                int currentBatch = 1;
                this.progress.setCurrentCount(0);
                this.progress.setTotalObjects(pagesAndBlogs.size());
                this.maxErrorsAllowed = this.getMaxNumberOfErrors(pagesAndBlogs.size());
                for (List<Long> pagesSubList : MiscUtils.partition(pagesAndBlogs, 100)) {
                    if (ClearWorkflowHistoryAction.this.accessModeService.isReadOnlyAccessModeEnabled()) {
                        throw new ReadOnlyException(ClearWorkflowHistoryAction.this.getText("com.comalatech.readonlymode.long.running.task.error"));
                    }
                    ClearWorkflowHistoryAction.this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRED, () -> this.clearPageWorkflowHistory(pagesSubList));
                    this.progress.setPercentage(currentBatch, totalBatches);
                    ++currentBatch;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Batch " + currentBatch + " out of " + totalBatches + "successfully completed");
                }
                ClearWorkflowHistoryAction.this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRED, () -> this.clearSpaceRoles(ClearWorkflowHistoryAction.this.getSpaceKey()));
                if (this.errors > 0) {
                    this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.completed.error", new Object[]{pagesAndBlogs.size(), this.errors}));
                    if (log.isDebugEnabled()) {
                        log.debug("Workflow Content Properties population task completed with errors");
                    }
                    this.progress.setCurrentCount(pagesAndBlogs.size());
                    this.progress.setCompletedSuccessfully(false);
                } else {
                    if (this.totalValidationErrors > 0) {
                        this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.completed.validation", new Object[]{pagesAndBlogs.size(), this.totalValidationErrors}));
                        if (log.isDebugEnabled()) {
                            log.debug("Workflow Content Properties population task completed with " + this.totalValidationErrors + " validation errors");
                        }
                    } else {
                        this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.completed.ok", new Object[]{pagesAndBlogs.size()}));
                        if (log.isDebugEnabled()) {
                            log.debug("Workflow Content Properties population task successfully completed");
                        }
                    }
                    this.progress.setCurrentCount(pagesAndBlogs.size());
                    this.progress.setCompletedSuccessfully(true);
                }
            }
            catch (Exception e) {
                this.progress.setPercentage(100);
                if (e.getMessage() != null) {
                    this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.status.error.exception", new Object[]{e.getMessage()}));
                    if (log.isDebugEnabled()) {
                        log.debug(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.status.error.exception", new Object[]{e.getMessage()}));
                    }
                } else {
                    this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.status.error"));
                    if (log.isDebugEnabled()) {
                        log.debug(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.status.error"));
                    }
                }
                this.progress.setCompletedSuccessfully(false);
            }
            finally {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
            }
        }

        private List<Long> getPagesToInitialise(String spaceKey) {
            return ClearWorkflowHistoryAction.this.getAllPages(spaceKey).stream().map(EntityObject::getId).collect(Collectors.toList());
        }

        private boolean clearPageWorkflowHistory(List<Long> batchPageIds) {
            block9: {
                ArrayList<String> successfullPagesAndBlogs = new ArrayList<String>();
                for (Long pageId : batchPageIds) {
                    block8: {
                        AbstractPage page = ClearWorkflowHistoryAction.this.pageManager.getAbstractPage(pageId.longValue());
                        this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
                        try {
                            boolean successfulValidations = ClearWorkflowHistoryAction.this.clearWorkflowHistoryService.clearPageWorkflowHistory(page, true, false);
                            if (!successfulValidations) {
                                ++this.totalValidationErrors;
                            } else {
                                successfullPagesAndBlogs.add(page.getIdAsString());
                            }
                            ++this.updated;
                        }
                        catch (Exception e) {
                            ++this.errors;
                            log.error("There has been an error processing the page " + pageId, (Throwable)e);
                            if (this.errors <= this.maxErrorsAllowed) break block8;
                            String error = ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.error", new Object[]{this.errors, this.updated});
                            log.error(error);
                            this.setErrorMessage(error);
                            this.progress.setStatus(this.errorMessage);
                            this.progress.setPercentage(100);
                            this.progress.setCompletedSuccessfully(false);
                            break;
                        }
                    }
                    this.progress.setStatus(ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.status", new Object[]{this.progress.getCurrentCount(), this.progress.getTotal(), this.updated, this.errors}));
                }
                if (this.errors <= this.maxErrorsAllowed) {
                    try {
                        ClearWorkflowHistoryAction.this.clearWorkflowHistoryService.clearUserMessages(successfullPagesAndBlogs);
                    }
                    catch (Exception e) {
                        ++this.errors;
                        log.error("There has been an error deleting user messages ", (Throwable)e);
                        if (this.errors <= this.maxErrorsAllowed) break block9;
                        String error = ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.error", new Object[]{this.errors, this.updated});
                        log.error(error);
                        this.setErrorMessage(error);
                        this.progress.setStatus(this.errorMessage);
                        this.progress.setPercentage(100);
                        this.progress.setCompletedSuccessfully(false);
                    }
                }
            }
            return true;
        }

        private boolean clearSpaceRoles(String spaceKey) {
            return ClearWorkflowHistoryAction.this.clearWorkflowHistoryService.clearSpaceRolesHistory(spaceKey);
        }

        private int getMaxNumberOfErrors(int numberOfPages) {
            int maxErrorsAllowed;
            int n = maxErrorsAllowed = numberOfPages > 50 ? numberOfPages / 10 : 20;
            if (maxErrorsAllowed > 100) {
                maxErrorsAllowed = 100;
            }
            return maxErrorsAllowed;
        }

        public String getName() {
            return ClearWorkflowHistoryAction.this.getText("awp.space.clearHistory.title");
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

