/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.model.SpaceWorkflowInstance;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class SpaceWorkflowReportEntry {
    private static final String GLOBAL_SPACE_TYPE = "GLOBAL";
    private SpaceWorkflowInstance spaceWorkflowInstance;
    private Long workflowPageCount;
    private Long spacePageCount;
    private Date lastPageUpdateInSpace;

    public String getWorkflowLabels() {
        List<Label> labels = this.spaceWorkflowInstance.getLabels();
        if (labels == null || labels.isEmpty()) {
            return "";
        }
        return labels.stream().map(Label::getName).collect(Collectors.joining(","));
    }

    public String getWorkflowTypeForCsv() {
        if (this.spaceWorkflowInstance == null || this.spaceWorkflowInstance.getWorkflowType() == null) {
            return "";
        }
        return this.spaceWorkflowInstance.getWorkflowType().equals((Object)Workflow.WorkflowType.LINKED_SPACE) ? GLOBAL_SPACE_TYPE : this.spaceWorkflowInstance.getWorkflowType().toString();
    }

    public static SpaceWorkflowReportEntryBuilder builder() {
        return new SpaceWorkflowReportEntryBuilder();
    }

    public SpaceWorkflowInstance getSpaceWorkflowInstance() {
        return this.spaceWorkflowInstance;
    }

    public Long getWorkflowPageCount() {
        return this.workflowPageCount;
    }

    public Long getSpacePageCount() {
        return this.spacePageCount;
    }

    public Date getLastPageUpdateInSpace() {
        return this.lastPageUpdateInSpace;
    }

    public void setSpaceWorkflowInstance(SpaceWorkflowInstance spaceWorkflowInstance) {
        this.spaceWorkflowInstance = spaceWorkflowInstance;
    }

    public void setWorkflowPageCount(Long workflowPageCount) {
        this.workflowPageCount = workflowPageCount;
    }

    public void setSpacePageCount(Long spacePageCount) {
        this.spacePageCount = spacePageCount;
    }

    public void setLastPageUpdateInSpace(Date lastPageUpdateInSpace) {
        this.lastPageUpdateInSpace = lastPageUpdateInSpace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceWorkflowReportEntry)) {
            return false;
        }
        SpaceWorkflowReportEntry other = (SpaceWorkflowReportEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$workflowPageCount = this.getWorkflowPageCount();
        Long other$workflowPageCount = other.getWorkflowPageCount();
        if (this$workflowPageCount == null ? other$workflowPageCount != null : !((Object)this$workflowPageCount).equals(other$workflowPageCount)) {
            return false;
        }
        Long this$spacePageCount = this.getSpacePageCount();
        Long other$spacePageCount = other.getSpacePageCount();
        if (this$spacePageCount == null ? other$spacePageCount != null : !((Object)this$spacePageCount).equals(other$spacePageCount)) {
            return false;
        }
        SpaceWorkflowInstance this$spaceWorkflowInstance = this.getSpaceWorkflowInstance();
        SpaceWorkflowInstance other$spaceWorkflowInstance = other.getSpaceWorkflowInstance();
        if (this$spaceWorkflowInstance == null ? other$spaceWorkflowInstance != null : !((Object)this$spaceWorkflowInstance).equals(other$spaceWorkflowInstance)) {
            return false;
        }
        Date this$lastPageUpdateInSpace = this.getLastPageUpdateInSpace();
        Date other$lastPageUpdateInSpace = other.getLastPageUpdateInSpace();
        return !(this$lastPageUpdateInSpace == null ? other$lastPageUpdateInSpace != null : !((Object)this$lastPageUpdateInSpace).equals(other$lastPageUpdateInSpace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpaceWorkflowReportEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $workflowPageCount = this.getWorkflowPageCount();
        result = result * 59 + ($workflowPageCount == null ? 43 : ((Object)$workflowPageCount).hashCode());
        Long $spacePageCount = this.getSpacePageCount();
        result = result * 59 + ($spacePageCount == null ? 43 : ((Object)$spacePageCount).hashCode());
        SpaceWorkflowInstance $spaceWorkflowInstance = this.getSpaceWorkflowInstance();
        result = result * 59 + ($spaceWorkflowInstance == null ? 43 : ((Object)$spaceWorkflowInstance).hashCode());
        Date $lastPageUpdateInSpace = this.getLastPageUpdateInSpace();
        result = result * 59 + ($lastPageUpdateInSpace == null ? 43 : ((Object)$lastPageUpdateInSpace).hashCode());
        return result;
    }

    public String toString() {
        return "SpaceWorkflowReportEntry(spaceWorkflowInstance=" + this.getSpaceWorkflowInstance() + ", workflowPageCount=" + this.getWorkflowPageCount() + ", spacePageCount=" + this.getSpacePageCount() + ", lastPageUpdateInSpace=" + this.getLastPageUpdateInSpace() + ")";
    }

    public SpaceWorkflowReportEntry() {
    }

    public SpaceWorkflowReportEntry(SpaceWorkflowInstance spaceWorkflowInstance, Long workflowPageCount, Long spacePageCount, Date lastPageUpdateInSpace) {
        this.spaceWorkflowInstance = spaceWorkflowInstance;
        this.workflowPageCount = workflowPageCount;
        this.spacePageCount = spacePageCount;
        this.lastPageUpdateInSpace = lastPageUpdateInSpace;
    }

    public static class SpaceWorkflowReportEntryBuilder {
        private SpaceWorkflowInstance spaceWorkflowInstance;
        private Long workflowPageCount;
        private Long spacePageCount;
        private Date lastPageUpdateInSpace;

        SpaceWorkflowReportEntryBuilder() {
        }

        public SpaceWorkflowReportEntryBuilder spaceWorkflowInstance(SpaceWorkflowInstance spaceWorkflowInstance) {
            this.spaceWorkflowInstance = spaceWorkflowInstance;
            return this;
        }

        public SpaceWorkflowReportEntryBuilder workflowPageCount(Long workflowPageCount) {
            this.workflowPageCount = workflowPageCount;
            return this;
        }

        public SpaceWorkflowReportEntryBuilder spacePageCount(Long spacePageCount) {
            this.spacePageCount = spacePageCount;
            return this;
        }

        public SpaceWorkflowReportEntryBuilder lastPageUpdateInSpace(Date lastPageUpdateInSpace) {
            this.lastPageUpdateInSpace = lastPageUpdateInSpace;
            return this;
        }

        public SpaceWorkflowReportEntry build() {
            return new SpaceWorkflowReportEntry(this.spaceWorkflowInstance, this.workflowPageCount, this.spacePageCount, this.lastPageUpdateInSpace);
        }

        public String toString() {
            return "SpaceWorkflowReportEntry.SpaceWorkflowReportEntryBuilder(spaceWorkflowInstance=" + this.spaceWorkflowInstance + ", workflowPageCount=" + this.workflowPageCount + ", spacePageCount=" + this.spacePageCount + ", lastPageUpdateInSpace=" + this.lastPageUpdateInSpace + ")";
        }
    }
}

