/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.PageActivityData;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvServiceImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="pageActivityDataPopulator")
public class PageActivityDataPopulator
implements SupportConsoleReportDataPopulator<PageActivityData, AbstractPage> {
    private final ActivityManager activityManager;
    private final PageActivityCsvServiceImpl pageActivityCsvService;

    public PageActivityDataPopulator(ActivityManager activityManager, PageActivityCsvServiceImpl pageActivityCsvService) {
        this.activityManager = activityManager;
        this.pageActivityCsvService = pageActivityCsvService;
    }

    @Override
    public PageActivityData populateForTarget(AbstractPage page) {
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(page, this.getOptions());
        return PageActivityData.builder().activityReport(this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, page, PageActivityCsvConfig.builder().skipOtherVersion(false).build())).build();
    }

    private ActivityReportOptions getOptions() {
        ActivityReportOptions options = new ActivityReportOptions();
        options.setAscending(false);
        options.setHideComments(false);
        options.setHideTasks(false);
        options.setHideEdits(false);
        options.setHideStates(false);
        options.setPublishView(false);
        return options;
    }
}

