/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.state;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.metadata.atlassian.AtlassianMetadataHandler;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.page.PageStateTransitionEvent;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(StateTransitionTriggersListener.class);
    private final StateHandler stateHandler;
    private final AtlassianMetadataHandler atlassianMetadataHandler;

    public StateTransitionTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, @ComponentImport EventPublisher eventPublisher, StateHandler stateHandler, AtlassianMetadataHandler atlassianMetadataHandler, EventHistoryManager eventHistoryManager, @ComponentImport DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.stateHandler = stateHandler;
        this.atlassianMetadataHandler = atlassianMetadataHandler;
    }

    @EventListener
    public void onBlogPostStateTransitionEvent(BlogPostStateTransitionEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @EventListener
    public void onPageStateTransitionEvent(PageStateTransitionEvent event) {
        this.handleEventTrigger((ContentEvent)event);
    }

    @Override
    public void handleEventTrigger(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            if (this.atlassianMetadataHandler.updateProperties((AbstractPage)((StateTransitionEvent)event).getContent(), pageWorkflows)) {
                try {
                    pageWorkflows = this.workflowAccessor.getWorkflows(pageWorkflows.getPage(), (ConfluenceEvent)event);
                }
                catch (WorkflowException e) {
                    if (log.isDebugEnabled()) {
                        log.error("", (Throwable)e);
                    }
                    log.error(e.getMessage());
                }
            }
            this.stateHandler.handle((StateTransitionEvent)event, pageWorkflows);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

