/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.webresource.compat;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.comalatech.confluence.webresource.compat.WebResourceManagerCompat;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceManagerConf9
implements WebResourceManagerCompat {
    private static final Logger log = LoggerFactory.getLogger(WebResourceManagerConf9.class);
    private final Object confluenceWebResource;
    private final Method requireResource;

    public WebResourceManagerConf9(Object confluenceWebResource) throws ReflectiveOperationException {
        this.confluenceWebResource = confluenceWebResource;
        this.requireResource = this.getConfluenceWebResourceManagerMethod("requireResource", String.class);
    }

    @Override
    public void requireResource(String resource) {
        try {
            this.requireResource.invoke(this.confluenceWebResource, resource);
            log.debug("requireResource conf9 method invoked");
        }
        catch (Exception e) {
            throw new ServiceException("Could not invoke to requireResource method from WebResourceManagerConf9", (Throwable)e);
        }
    }

    private Method getConfluenceWebResourceManagerMethod(String methodName, Class<?> ... parameterTypes) throws ReflectiveOperationException {
        return Class.forName("com.atlassian.webresource.api.WebResourceManager").getMethod(methodName, parameterTypes);
    }
}

