/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateInitEvent;
import com.comalatech.confluence.states.event.page.PageStateInitEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class StateInitMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateInitMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageStateInitEvent) {
            PageStateInitEvent pageStateInitEvent = (PageStateInitEvent)event;
            return this.buildActivity((AbstractPage)pageStateInitEvent.getPage(), pageStateInitEvent.getState(), pageStateInitEvent.getPreviousEvent());
        }
        if (event instanceof BlogPostStateInitEvent) {
            BlogPostStateInitEvent blogPostStateInitEvent = (BlogPostStateInitEvent)event;
            return this.buildActivity((AbstractPage)blogPostStateInitEvent.getBlogPost(), blogPostStateInitEvent.getState(), blogPostStateInitEvent.getPreviousEvent());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState targetState, PageState sourceState) throws WorkflowUserException {
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(targetState));
        if (sourceState != null) {
            details.addDetail(ActionDetailType.STATE_SOURCE, sourceState.getName());
        }
        if (targetState.getComment() != null && !targetState.getComment().isEmpty()) {
            details.addDetail(ActionDetailType.STATE_COMMENT, targetState.getComment());
        } else {
            details.addDetail(ActionDetailType.STATE_COMMENT, ComalaI18nBean.getComalaI18nBean().getText(targetState.getStateChangeReason().getI18nName()));
        }
        Action action = new Action(new ActionType(ActionType.Type.STATE, ActionType.Subtype.STATE_INIT), this.actorUtils.buildActor(targetState.getPerformer()), details);
        return new Activity(StateInitMapper.buildTarget((ContentEntityObject)abstractPage), targetState.getDate().getTime(), action);
    }
}

