/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.states.model.PageState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenerateValidatedPageActivityMigrationData
implements GeneratePageActivityMigrationData {
    private static final Logger log = LoggerFactory.getLogger(GenerateValidatedPageActivityMigrationData.class);
    private final GeneratePageActivity generatePageActivity;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;

    public GenerateValidatedPageActivityMigrationData(GeneratePageActivity generatePageActivity, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager) {
        this.generatePageActivity = generatePageActivity;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
    }

    @Override
    public Map<AbstractPage, LinkedHashMap<PageState, List<Activity>>> getActivities(List<String> spaceKeysList) throws RuntimeException {
        HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>> result = new HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>>();
        AtomicInteger totalPages = new AtomicInteger(0);
        ArrayList pagesNotExported = new ArrayList();
        for (String currentSpace : spaceKeysList) {
            Space space = this.spaceManager.getSpace(currentSpace);
            if (space == null) continue;
            Stream pages = this.pageManager.getPages(space, true).stream();
            Stream blogs = this.pageManager.getBlogPosts(space, true).stream();
            Stream pageStream = Stream.concat(pages, blogs);
            pageStream.filter(p -> !p.isDraft()).forEach(currentPage -> {
                LinkedHashMap<PageState, List<Activity>> activities;
                totalPages.incrementAndGet();
                try {
                    activities = this.generatePageActivity.generateCurrentStateActivities((AbstractPage)currentPage);
                }
                catch (Exception e) {
                    log.error("There has been an error retrieving the content activities for {}", (Object)currentPage.getIdAsString());
                    throw new RuntimeException(e);
                }
                if (activities != null && !activities.isEmpty()) {
                    result.put((AbstractPage)currentPage, activities);
                } else {
                    pagesNotExported.add(currentPage.getId());
                    log.debug("Page id {} not added to page activities list: list empty ? {}", (Object)currentPage.getId(), (Object)(activities == null || activities.isEmpty() ? 1 : 0));
                }
            });
            if (pagesNotExported.isEmpty()) {
                log.info("{} pages of space {} have been successfully exported", (Object)totalPages.get(), (Object)space.getName());
            } else {
                log.warn("{} of {} pages of space {} have been successfully exported", new Object[]{totalPages.get() - pagesNotExported.size(), totalPages.get(), space.getName()});
                log.warn("The following pages, {} in total, were not exported because do not have any workflow activity: {}", (Object)pagesNotExported.size(), (Object)Arrays.toString(pagesNotExported.toArray()));
            }
            totalPages.set(0);
            pagesNotExported.clear();
        }
        return result;
    }
}

