/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    function isNotStandardTheme($builder) {
        var $body = $('body');
        return (
            // Refined Theme
            !$body.hasClass('aui-theme-default') || !$body.hasClass('theme-default') ||
            // Brikit
            $body.hasClass('brikit') ||
            // Theme Builder
            $builder.parents('.ia-splitter').length
        );
    };

    function getBackUrl(baseUrl, spaceKey, pageId, type) {
        if (pageId) {
            return baseUrl + '/pages/viewpage.action?pageId=' + pageId;
        } else if (spaceKey) {
            return baseUrl + '/spaces/' + (
                CW.getParam('isWorkflowsLiteApp') ? 'workflowslitespaceconfig.action?spaceKey=' : 'viewspaceworkflows.action?key='
            ) + spaceKey + '&section=' + (
                    type === 'page-template' ? 'page' : 'space'
                );
        }
        return baseUrl + '/admin/viewglobalworkflows.action';
    }

    function getIframeUrl(mode, workflowId, spaceKey, pageId) {
        var url = '/' + (mode === 'markup' ? 'markup' : 'builder');
        if (spaceKey) {
            url += '/' + spaceKey;
            if (pageId) {
                url += '/' + pageId;
            }
        }
        url += '/' + workflowId;
        return url;
    }

    function getIframeHeight() {
        const rw_banner = $('.rw_license_banner');
        var offset = $('#rw_theme_header').length ?
            (
                // Refined Theme
                $('#rw_theme_header').outerHeight(true) +
                $('#rw_menu_bar_wrapper').outerHeight(true) +
                $('#rw_footer_wrapper').outerHeight(true) +
                (rw_banner.length ? rw_banner.outerHeight(true) : 0)
            )
            : (
                // Brikit && Theme Builder
                $('#header').outerHeight(true) +
                $('#footer').outerHeight(true)
            );
        return window.innerHeight - offset;
    };

    function getIframeQuery(workflowType) {
        var query = {
            isSpaceAdmin: CW.isSpaceAdmin(),
            isConfluenceAdmin: CW.isConfluenceAdmin(),
            workflowType: workflowType,
            showTranslator: CW.showWorkflowTranslator()
        };
        if (CW.getParam('pageTitle')) {
            query.pageTitle = CW.getParam('pageTitle');
        }
        if (CW.getParam('spaceName')) {
            query.spaceName = CW.getParam('spaceName');
        }
        return query;
    }

    CW.toInit(function () {
        var qs = CW.queryString();
        var $builder = $('#cwbuilder');

        var iframeHeight = '100%';
        if (isNotStandardTheme($builder)) {
            // Theme compat
            iframeHeight = getIframeHeight();
            $(window).on('resize', function () {
                $builder.find('iframe').attr('height', getIframeHeight());
            });
        }

        var workflowId = qs.create ? 'create' : (qs.id || $builder.data('id'));
        var pageId = qs.pageId || CW.getParam('pageId');
        var spaceKey = qs.key || CW.getParam('spaceKey');
        var workflowType = qs.type || (pageId && 'page') || (spaceKey && 'space') || 'global';
        var mode = CW.getParam('isWorkflowsApp') && qs.mode ? qs.mode : 'builder';
        var iframe = new CW.iframe({
            id: 'cwbuilder-iframe',
            url: getIframeUrl(mode, workflowId, spaceKey, pageId),
            height: iframeHeight,
            scrolling: 'auto',
            query: getIframeQuery(workflowType)
        });
        $builder.html(iframe.render());

        // go back to space / global admin workflows
        CW.connect('back', function (querystring) {
            var newUrl = getBackUrl(CW.getParam('baseUrl'), spaceKey, pageId, workflowType);
            if (querystring) {
                newUrl += (newUrl.indexOf('?') >= 0 ? '&' : '?') + querystring;
            }
            window.location.href = newUrl;
        });
    });
});
