/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
(function ($) {

    var showGettingStartedDialog = function () {

        document.addEventListener('DOMContentLoaded', function() {
            // Append the dialog HTML to the body if it doesn't exist
            if (!document.getElementById('getting-started-dialog')) {
                document.body.insertAdjacentHTML('beforeend', `
                    <div id="getting-started-dialog" class="aui-dialog2 aui-dialog2-large" role="dialog">
                        <header class="aui-dialog2-header">
                            <h2 class="aui-dialog2-header-main">Getting Started</h2>
                        </header>
                        <div class="aui-dialog2-content">
                            <p>Welcome to the Getting Started guide!</p>
                        </div>
                        <footer class="aui-dialog2-footer">
                            <div class="aui-dialog2-footer-actions">
                                <button id="close-button" class="aui-button aui-button-primary">Close</button>
                            </div>
                        </footer>
                    </div>
                `);
            }
        
            var dialog = AJS.dialog2('#getting-started-dialog');
        
            document.getElementById('close-button').addEventListener('click', function() {
                dialog.hide();
            });
        
            dialog.show();
        });
    }

    if (upm) {
        // For the "Get Started" button
        $("div.upm-details").live(
            "detailsLoaded",
            function(ev) {
                if (upm.createHash) { //Some older versions of the UPM don't have this. The Get started buttons don't seem to exist in these UPM versions anyway.
                    $("#upm-plugin-" + upm.createHash("com.comalatech.workflow", "manage") + " .upm-get-started").unbind("click").click(function(ev) {
                        showGettingStartedDialog();
                        return false;
                    });
                }
            }
        );

        var isWorkflowsRelated = function (pluginStatusDialog){
            return pluginStatusDialog.id === "upm-plugin-status-dialog" &&
                $(".plugin-name-version .plugin-name", pluginStatusDialog.getPage(0).body).text() === "Comala Workflows";
        };

        var defaultUpmStatusDialog = upm.showPluginStatusDialog;
        upm.showPluginStatusDialog = function(heading, pluginElement, body, button, buttonHandler, htmlBody) {
            defaultUpmStatusDialog(
                heading,
                pluginElement,
                body,
                button,
                (function() {
                    return function(upmStatusDialog) {
                        if (isWorkflowsRelated(upmStatusDialog)) {
                            upmStatusDialog.remove();
                            showGettingStartedDialog();
                            return false;
                        } else if (buttonHandler) {
                            buttonHandler(upmStatusDialog);
                        }
                    }
                })(),
                htmlBody
            );
        };

    }

})(AJS.$);
