/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.supplier;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.SourceCriterion;
import org.randombits.confluence.supplier.SupplierAssistant;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;
import org.randombits.facade.Facadable;

@Facadable
public class SupplierValueCriterion
implements SourceCriterion<Object> {
    private static final Logger LOG = Logger.getLogger(SupplierValueCriterion.class);
    private String key;
    private Criterion criterion;

    public SupplierValueCriterion(String key, Criterion criterion) {
        this.key = key;
        this.criterion = criterion;
    }

    @Override
    public boolean matches(Object object) {
        if (this.key != null) {
            try {
                object = SupplierAssistant.getInstance().findValue(object, this.key);
            }
            catch (UnsupportedContextException e) {
                LOG.warn((Object)("Unsupported context for key: " + this.key), (Throwable)e);
                return false;
            }
            catch (SupplierException e) {
                LOG.error((Object)("Supplier exception for key: " + this.key), (Throwable)e);
            }
        }
        return this.criterion.matches(object);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "{supplier; key: " + this.key + "; criterion: " + this.criterion + "}";
    }

    @Override
    public Collection<Object> getMatchingValues() {
        if (this.criterion instanceof SourceCriterion) {
            return ((SourceCriterion)this.criterion).getMatchingValues();
        }
        return null;
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return SourceCriterion.Weight.MEDIUM;
    }
}

