/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ApprovalActivity;
import com.comalatech.confluence.workflowreports.model.CommentActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.Assignment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PageActivityCsvEntryProcessorLegacy
extends PageActivityCsvProcessor {
    protected final PageManager pageManager;
    protected final ReportDateFormatter dateFormatter;

    public PageActivityCsvEntryProcessorLegacy(PageManager pageManager, ReportDateFormatter dateFormatter, I18nResolver i18nResolver) {
        super(i18nResolver);
        this.pageManager = pageManager;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public <E> void processEntry(CSVBuilder csv, AbstractPage page, E entry) {
        ActivityReportEntry activityReportEntry = (ActivityReportEntry)entry;
        List<ActivityEntry> activityEntries = activityReportEntry.getActivityEntries();
        for (ActivityEntry activityEntry : activityEntries) {
            List<Activity> activities = activityEntry.getActivities();
            Collections.reverse(activities);
            for (Activity activity : activities) {
                List<String> contributors;
                String formattedDate = this.dateFormatter.formatServerDateTimePrecise(activity.getDate());
                csv.addCell(formattedDate);
                String username = activity.getPerformer();
                csv.addCell(username == null ? this.getI18nText("com.comalatech.activity.report.csvexport.anonymous") : username);
                String contributorsCommaSeparated = "";
                if (activity instanceof ModificationActivity && (contributors = ((ModificationActivity)activity).getContributorsUsernames()) != null && !contributors.isEmpty()) {
                    contributorsCommaSeparated = StringUtils.join(contributors, (String)",");
                }
                csv.addCell(contributorsCommaSeparated);
                csv.addCell(activity.getActivityKey());
                csv.addCell(this.getDescription(activity, activityEntry));
                this.addVersionContent(csv, page, activityEntry, activity);
                this.addComment(csv, activity);
                csv.newLine();
            }
        }
    }

    private void addVersionContent(CSVBuilder csv, AbstractPage page, ActivityEntry activityEntry, Activity activity) {
        Integer version = this.getVersion(activityEntry, activity);
        Object versionStr = "";
        String oldPageId = "";
        if (version != null) {
            ContentEntityObject oldPage;
            versionStr = "v" + version;
            if (!this.isSkipOtherVersion() && (oldPage = this.pageManager.getOtherVersion((ContentEntityObject)page, version.intValue())) != null) {
                oldPageId = String.valueOf(oldPage.getId());
            }
        }
        csv.addCell((String)versionStr);
        csv.addCell(oldPageId);
    }

    private void addComment(CSVBuilder csv, Activity activity) {
        if (activity.getComment() != null && !activity.getComment().trim().isEmpty()) {
            csv.addCell(PageActivityEntryProcessor.removeHtmlTags(activity.getComment()));
        } else if ("state".equals(activity.getActivityKey())) {
            PageState pageState = (PageState)activity;
            if (pageState.getStateChangeReason() != null) {
                csv.addCell(this.getI18nText(pageState.getStateChangeReason().getI18nName()));
            } else {
                csv.addCell("");
            }
        } else {
            csv.addCell("");
        }
    }

    private Integer getVersion(ActivityEntry activityEntry, Activity activity) {
        Integer version = null;
        if (activity instanceof ModificationActivity) {
            version = ((ModificationActivity)activity).getVersion();
        } else if (activity instanceof ApprovalActivity) {
            version = activityEntry.getApprovalCheck().getVersion();
        } else if (activity instanceof ReadAckActivity) {
            version = ((ReadAckActivity)activity).getVersion();
        } else if (activityEntry.getPageState() != null) {
            version = activityEntry.getPageState().getContentVersion();
        } else if (activityEntry.getApprovalCheck() != null) {
            version = activityEntry.getApprovalCheck().getVersion();
        }
        return version;
    }

    private String getDescription(Activity activity, ActivityEntry activityEntry) {
        String description;
        switch (activity.getActivityKey()) {
            case "approval": {
                description = this.getApprovalDescription(activity);
                break;
            }
            case "approval-assignment": {
                description = this.getApprovalAssignmentDescription(activity, activityEntry);
                break;
            }
            case "approval-unassignment": {
                description = this.getApprovalUnassignmentDescription(activity, activityEntry);
                break;
            }
            case "assignment": {
                description = this.getAssignmentDescription(activity, activityEntry);
                break;
            }
            case "comment": {
                description = this.getCommentDescription(activity);
                break;
            }
            case "completion": {
                description = this.getCompletionDescription(activity, activityEntry);
                break;
            }
            case "deletion": {
                description = this.getDeletionDescription(activity, activityEntry);
                break;
            }
            case "duedaterecord": {
                description = this.getDueDateRecordDescription(activity, activityEntry);
                break;
            }
            case "duedaterecordexpiry": {
                description = this.getDueDateRecordExpiryDescription(activityEntry);
                break;
            }
            case "modification": {
                description = this.getModificationDescription(activity);
                break;
            }
            case "read-ack": {
                description = this.getReadAckDescription(activity);
                break;
            }
            case "state": {
                description = this.getStateDescription(activity);
                break;
            }
            case "task": {
                description = this.getTaskDescription(activity, activityEntry);
                break;
            }
            default: {
                description = "";
            }
        }
        return PageActivityEntryProcessor.removeHtmlTags(description);
    }

    private String getApprovalDescription(Activity activity) {
        ApprovalActivity approvalActivity = (ApprovalActivity)activity;
        String roleName = approvalActivity.getApprover().getRole();
        if (!approvalActivity.getApprover().isApproved()) {
            if (roleName != null && roleName.length() > 0) {
                return this.getI18nText("com.comalatech.activity.report.approval.rejected.role", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), this.getSignatureMode(approvalActivity), roleName});
            }
            return this.getI18nText("com.comalatech.activity.report.approval.rejected", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), this.getSignatureMode(approvalActivity)});
        }
        if (roleName != null && roleName.length() > 0) {
            return this.getI18nText("com.comalatech.activity.report.approval.approved.role", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), this.getSignatureMode(approvalActivity), roleName});
        }
        return this.getI18nText("com.comalatech.activity.report.approval.approved", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), this.getSignatureMode(approvalActivity)});
    }

    private String getApprovalAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        com.comalatech.confluence.states.model.Assignment approvalAssignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (approvalAssignment.getRolename() != null && approvalAssignment.getRolename().length() > 0) {
            return this.getI18nText("com.comalatech.activity.report.approval.assigned.role", new String[]{activityEntry.getApprovalCheck().getName(), approvalAssignment.getAssignee(), this.dateFormatter.formatServerTime(approvalAssignment.getDate()), approvalAssignment.getRolename()});
        }
        return this.getI18nText("com.comalatech.activity.report.approval.assigned", new String[]{activityEntry.getApprovalCheck().getName(), approvalAssignment.getAssignee(), this.dateFormatter.formatServerTime(approvalAssignment.getDate())});
    }

    private String getApprovalUnassignmentDescription(Activity activity, ActivityEntry activityEntry) {
        Assignment assignment = (Assignment)((Object)activity);
        return this.getI18nText("com.comalatech.activity.report.approval.unassigned", new String[]{activityEntry.getApprovalCheck().getName(), assignment.getAssignee(), this.dateFormatter.formatServerTime(assignment.getDate())});
    }

    private String getAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        String name = "'" + activityEntry.getPageTask().getName() + "'";
        com.comalatech.confluence.states.model.Assignment assignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (assignment.getAssignee() != null && !assignment.getAssignee().isEmpty()) {
            return this.getI18nText("com.comalatech.activity.report.task.assigned", new String[]{name, assignment.getAssignee(), this.dateFormatter.formatServerTime(assignment.getDate())});
        }
        return this.getI18nText("com.comalatech.activity.report.task.unassigned", new String[]{name, this.dateFormatter.formatServerTime(assignment.getDate())});
    }

    private String getDueDateRecordDescription(Activity activity, ActivityEntry activityEntry) {
        DueDateRecord dueDateRecord = (DueDateRecord)activity;
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            if (dueDateRecord.getDueDate() != null) {
                return this.getI18nText("com.comalatech.activity.report.dueDateRecord.task", new String[]{pageTaskName, this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
            }
            return this.getI18nText("com.comalatech.activity.report.dueDateRecord.task.remove", new String[]{pageTaskName, this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
        }
        if (activityEntry.getApprovalCheck() != null) {
            if (dueDateRecord.getDueDate() != null) {
                return this.getI18nText("com.comalatech.activity.report.dueDateRecord.approval", new String[]{activityEntry.getApprovalCheck().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(activity.getDate())});
            }
            return this.getI18nText("com.comalatech.activity.report.dueDateRecord.approval.remove", new String[]{activityEntry.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
        }
        if (dueDateRecord.getDueDate() != null) {
            return this.getI18nText("com.comalatech.activity.report.dueDateRecord.state", new String[]{activityEntry.getPageState().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(activity.getDate())});
        }
        return this.getI18nText("com.comalatech.activity.report.dueDateRecord.state.remove", new String[]{activityEntry.getPageState().getName(), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
    }

    private String getStateDescription(Activity activity) {
        PageState pageState = (PageState)activity;
        StringBuilder description = new StringBuilder();
        if (pageState.getLastAssignment() != null) {
            description.append(this.getI18nText("com.comalatech.activity.report.changed-state.assigned", new String[]{pageState.getState(), ((com.comalatech.confluence.states.model.Assignment)pageState.getLastAssignment()).getAssignee(), this.dateFormatter.formatServerTime(activity.getDate())}));
        } else {
            description.append(this.getI18nText("com.comalatech.activity.report.changed-state", new String[]{pageState.getState(), this.dateFormatter.formatServerTime(activity.getDate())}));
        }
        if (pageState.getStateChangeReason() != null) {
            description.append(" (").append(this.getI18nText(pageState.getStateChangeReason().getI18nName())).append(")");
        }
        return description.toString();
    }

    private String getModificationDescription(Activity activity) {
        ModificationActivity modification = (ModificationActivity)activity;
        if (modification.isCreation()) {
            return this.getI18nText("com.comalatech.activity.report.created", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
        }
        return this.getI18nText("com.comalatech.activity.report.modified", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
    }

    private String getTaskDescription(Activity activity, ActivityEntry activityEntry) {
        PageTask pageTask = (PageTask)activity;
        String taskName = "'" + pageTask.getName() + "'";
        if (pageTask.getType().isQuestion()) {
            String activityUsers = "";
            List<String> users = activityEntry.getActivityUsers();
            if (users != null && !users.isEmpty()) {
                activityUsers = String.join((CharSequence)" ", users);
            }
            return this.getI18nText("com.comalatech.activity.report.task.question-asked", new String[]{taskName, activityUsers, this.dateFormatter.formatServerTime(pageTask.getDate())});
        }
        return this.getI18nText("com.comalatech.activity.report.task.created", new String[]{taskName, this.dateFormatter.formatServerTime(pageTask.getDate())});
    }

    private String getDueDateRecordExpiryDescription(ActivityEntry activityEntry) {
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            return this.getI18nText("com.comalatech.activity.report.dueDateRecord.task.expired", new String[]{pageTaskName});
        }
        return this.getI18nText("com.comalatech.activity.report.dueDateRecord.approval.expired", new String[]{activityEntry.getApprovalCheck().getName()});
    }

    private String getCompletionDescription(Activity activity, ActivityEntry activityEntry) {
        TaskCompletion taskCompletion = (TaskCompletion)activity;
        PageTask pageTask = activityEntry.getPageTask();
        return this.getI18nText("com.comalatech.activity.report.task.completed", new String[]{"'" + pageTask.getName() + "'", this.dateFormatter.formatServerTime(taskCompletion.getDate())});
    }

    private String getCommentDescription(Activity activity) {
        CommentActivity commentActivity = (CommentActivity)activity;
        return this.getI18nText("com.comalatech.activity.report.task.commented", new String[]{this.dateFormatter.formatServerTime(commentActivity.getDate())});
    }

    private String getReadAckDescription(Activity activity) {
        return this.getI18nText("readack.activity.report.confirmed.description", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
    }

    private String getDeletionDescription(Activity activity, ActivityEntry activityEntry) {
        return this.getI18nText("com.comalatech.activity.report.task.deleted", new String[]{"'" + activityEntry.getPageTask().getName() + "'", this.dateFormatter.formatServerTime(activity.getDate())});
    }

    public String getSignatureMode(ApprovalActivity approvalActivity) {
        Approver approver = approvalActivity.getApprover();
        String signatureMode = "";
        if (Objects.isNull(approver)) {
            return "";
        }
        if (ESignatureCredentials.Credentials.CONFLUENCE.equals((Object)approver.getESignature())) {
            signatureMode = this.getConfluenceSignatureMode(approver.getSignatureType());
        } else if (ESignatureCredentials.Credentials.OTP.equals((Object)approver.getESignature())) {
            signatureMode = this.getOTPSignatureMode(approver.getSignatureType());
        }
        return signatureMode;
    }
}

