/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.CommonWorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlOperators;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlParam;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlPrintable;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportOptionsCqlUtility {
    private static final Logger log = LoggerFactory.getLogger(AbstractReportOptionsCqlUtility.class);
    protected final CommonWorkflowReportOptions options;
    protected final ObjectMapper objectMapper;
    protected static final String CQL_KEY = "cqlQuery";
    private static final String SPACE_NAME = "space";
    private static final String PARENT_NAME = "parent";
    private static final String ANCESTOR_NAME = "ancestor";
    private static final String LABEL_NAME = "label";
    private static final String STATES_NAME = "state";
    private static final String WORKFLOW_NAME = "workflowname";
    protected static final String SHOW_LIVE_FILTERING_KEY = "showLiveFiltering";
    protected static final String PRE_SELECTED_STATES_KEY = "preSelectedStates";
    protected static final String PRE_SELECTED_WORKFLOWS_KEY = "preSelectedWorkflows";

    protected AbstractReportOptionsCqlUtility(CommonWorkflowReportOptions options, ObjectMapper objectMapper) {
        this.options = options;
        this.objectMapper = objectMapper;
    }

    Map<String, ?> propertiesForLiveFiltering() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        boolean enableLiveFilter = this.options.isSingleSpace();
        propertiesMap.put(SHOW_LIVE_FILTERING_KEY, enableLiveFilter);
        propertiesMap.put(PRE_SELECTED_STATES_KEY, this.toJson(enableLiveFilter ? this.options.getStates() : null));
        propertiesMap.put(PRE_SELECTED_WORKFLOWS_KEY, this.toJson(enableLiveFilter ? this.options.getWorkflows() : null));
        return propertiesMap;
    }

    private String toJson(Object parameter) {
        if (parameter == null) {
            return "";
        }
        try {
            return this.objectMapper.writeValueAsString(parameter);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return "";
        }
    }

    Map<String, String> propertiesForCql() {
        CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.AND).addCqlElement(this.buildSimpleCqlParam(SPACE_NAME, this.options.getSpaceKeys())).addCqlElement(this.buildSimpleCqlParam(PARENT_NAME, this.options.getParentPageId())).addCqlElement(this.buildSimpleCqlParam(ANCESTOR_NAME, this.options.getAncestorPageId())).addCqlElement(this.buildLabelsCqlParam());
        if (this.options.getCql() != null) {
            String cql = this.options.getCql();
            Object result = cqlGroup.toCqlString();
            if (((String)result).isEmpty()) {
                result = cql;
            } else if (!cql.isEmpty()) {
                result = (String)result + " AND " + cql;
            }
            return Collections.singletonMap(CQL_KEY, result);
        }
        if (this.options.getCqlFilters() != null) {
            this.options.getCqlFilters().forEach(field -> cqlGroup.addCqlElement(this.buildSimpleCqlParam(field.getName(), field.getValue())));
        }
        return Collections.singletonMap(CQL_KEY, cqlGroup.toCqlString());
    }

    Map<String, String> getCqlParams() {
        Map<String, String> cql = this.propertiesForCql();
        String cqlString = this.buildWorkflowCqlParams(cql.get(CQL_KEY));
        return Collections.singletonMap(CQL_KEY, cqlString);
    }

    String buildWorkflowCqlParams(String cql) {
        if (this.options.getStates().isEmpty() && this.options.getWorkflows().isEmpty()) {
            return cql;
        }
        CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.AND).addCqlElement(this.buildSimpleCqlParam(STATES_NAME, this.options.getStates())).addCqlElement(this.buildSimpleCqlParam(WORKFLOW_NAME, this.options.getWorkflows()));
        return cql.isEmpty() ? cqlGroup.toCqlString() : cql + " AND " + cqlGroup.toCqlString();
    }

    protected CqlPrintable buildLabelsCqlParam() {
        CqlPrintable labelsCql;
        if (this.options.isAllLabelsMandatory()) {
            CqlGroup labelsGroup = new CqlGroup();
            for (String label : this.options.getLabels()) {
                labelsGroup.addCqlElement(this.buildSimpleCqlParam(LABEL_NAME, label));
            }
            labelsCql = labelsGroup;
        } else {
            labelsCql = this.buildSimpleCqlParam(LABEL_NAME, this.options.getLabels());
        }
        return labelsCql;
    }

    protected CqlPrintable buildSimpleCqlParam(String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)value)) {
            return new CqlParam(name, value);
        }
        return null;
    }

    protected CqlPrintable buildSimpleCqlParam(String name, List<String> values) {
        List notEmptyValues = values.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)name) && !notEmptyValues.isEmpty()) {
            return new CqlParam(name, values);
        }
        return null;
    }
}

