/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.FieldSort;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import org.apache.commons.lang3.StringUtils;

public enum WorkflowReportSortEnum {
    CREATED_ASCENDING("created", "ascending", (SearchSort)new CreatedSort(SearchSort.Order.ASCENDING)),
    CREATED_DESCENDING("created", "descending", (SearchSort)new CreatedSort(SearchSort.Order.DESCENDING)),
    MODIFIED_ASCENDING("modified", "ascending", (SearchSort)new ModifiedSort(SearchSort.Order.ASCENDING)),
    MODIFIED_DESCENDING("modified", "descending", (SearchSort)new ModifiedSort(SearchSort.Order.DESCENDING)),
    MODIFIEDBY_ASCENDING("lastModifierDisplayName", "ascending", (SearchSort)new FieldSort("lastModifierDisplayName", SearchSort.Type.STRING, SearchSort.Order.ASCENDING)),
    MODIFIEDBY_DESCENDING("lastModifierDisplayName", "descending", (SearchSort)new FieldSort("lastModifierDisplayName", SearchSort.Type.STRING, SearchSort.Order.DESCENDING)),
    STATE_ASCENDING("pagestateName", "ascending", (SearchSort)new FieldSort("pagestateName", SearchSort.Type.STRING, SearchSort.Order.ASCENDING)),
    STATE_DESCENDING("pagestateName", "descending", (SearchSort)new FieldSort("pagestateName", SearchSort.Type.STRING, SearchSort.Order.DESCENDING)),
    STATECHANGED_ASCENDING("statechanged", "ascending", (SearchSort)new FieldSort("statechanged", SearchSort.Type.LONG, SearchSort.Order.ASCENDING)),
    STATECHANGED_DESCENDING("statechanged", "descending", (SearchSort)new FieldSort("statechanged", SearchSort.Type.LONG, SearchSort.Order.DESCENDING)),
    STATECHANGEDBY_ASCENDING("statechangedby", "ascending", (SearchSort)new FieldSort("statechangedby", SearchSort.Type.STRING, SearchSort.Order.ASCENDING)),
    STATECHANGEDBY_DESCENDING("statechangedby", "descending", (SearchSort)new FieldSort("statechangedby", SearchSort.Type.STRING, SearchSort.Order.DESCENDING)),
    ASSIGNEE_ASCENDING("assignee", "ascending", (SearchSort)new FieldSort("assignee", SearchSort.Type.STRING, SearchSort.Order.ASCENDING)),
    ASSIGNEE_DESCENDING("assignee", "descending", (SearchSort)new FieldSort("assignee", SearchSort.Type.STRING, SearchSort.Order.DESCENDING)),
    TITLE_ASCENDING("title", "ascending", (SearchSort)new TitleSort(SearchSort.Order.ASCENDING)),
    TITLE_DESCENDING("title", "descending", (SearchSort)new TitleSort(SearchSort.Order.DESCENDING)),
    DUEDATE_ASCENDING("earliestTaskDueDate", "ascending", (SearchSort)new FieldSort("earliestTaskDueDate", SearchSort.Type.LONG, SearchSort.Order.ASCENDING)),
    DUEDATE_DESCENDING("earliestTaskDueDate", "descending", (SearchSort)new FieldSort("earliestTaskDueDate", SearchSort.Type.LONG, SearchSort.Order.DESCENDING)),
    STATEEXPIRATION_ASCENDING("nextexpiration", "ascending", (SearchSort)new FieldSort("nextexpiration", SearchSort.Type.LONG, SearchSort.Order.ASCENDING)),
    STATEEXPIRATION_DESCENDING("nextexpiration", "descending", (SearchSort)new FieldSort("nextexpiration", SearchSort.Type.LONG, SearchSort.Order.DESCENDING)),
    READACKSTATUS_ASCENDING("readAckStatus", "ascending", (SearchSort)new FieldSort("readAckStatus", SearchSort.Type.STRING, SearchSort.Order.ASCENDING)),
    READACKSTATUS_DESCENDING("readAckStatus", "descending", (SearchSort)new FieldSort("readAckStatus", SearchSort.Type.STRING, SearchSort.Order.DESCENDING));

    public static final String DESCENDING = "descending";
    public static final String ASCENDING = "ascending";
    private static final String DEFAULT_ORDER = "descending";
    private String field;
    private String order;
    private SearchSort sort;

    private WorkflowReportSortEnum(String field, String order, SearchSort sort) {
        this.field = field;
        this.order = order;
        this.sort = sort;
    }

    public static WorkflowReportSortEnum getDefault() {
        return MODIFIED_DESCENDING;
    }

    public SearchSort getSort() {
        return this.sort;
    }

    public String getField() {
        return this.field;
    }

    public String getOrder() {
        return this.order;
    }

    public String getReverseOrder() {
        if (this.order.equals(ASCENDING)) {
            return "descending";
        }
        return ASCENDING;
    }

    public static SearchSort.Order getOrder(String order) {
        if (ASCENDING.equals(order)) {
            return SearchSort.Order.ASCENDING;
        }
        return SearchSort.Order.DESCENDING;
    }

    public static WorkflowReportSortEnum makeSort(String sortName, String order) {
        WorkflowReportSortEnum sort = WorkflowReportSortEnum.makeSortNoDefault(sortName, order);
        if (sort != null) {
            return sort;
        }
        return MODIFIED_DESCENDING;
    }

    public static WorkflowReportSortEnum makeSortNoDefault(String sort, String order) {
        if (!StringUtils.isNotBlank((CharSequence)order)) {
            order = "descending";
        }
        for (WorkflowReportSortEnum sortEnum : WorkflowReportSortEnum.values()) {
            if (!sortEnum.field.equalsIgnoreCase(sort) || !sortEnum.order.equalsIgnoreCase(order)) continue;
            return sortEnum;
        }
        return null;
    }
}

