/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.readack.activity.ReadAckActivityModel;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflowreports.model.ApprovalActivity;
import com.comalatech.confluence.workflowreports.model.CommentActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ActivityEntry
implements Comparable<ActivityEntry> {
    private PageState pageState;
    private PageTask pageTask;
    private ApprovalCheck approvalCheck;
    private List<Activity> activities = new ArrayList<Activity>();
    private List<String> activityUsers;
    private Date from;
    private Date to;
    public boolean currentState;

    private ActivityEntry(Activity activity) {
        this(activity, null, null, null);
    }

    private ActivityEntry(Activity activity, PageState pageState) {
        this(activity, pageState, null, null);
    }

    private ActivityEntry(Activity activity, PageState pageState, PageTask pageTask) {
        this(activity, pageState, pageTask, null);
    }

    private ActivityEntry(Activity activity, PageState pageState, ApprovalCheck approvalCheck) {
        this(activity, pageState, null, approvalCheck);
    }

    private ActivityEntry(Activity activity, PageState pageState, PageTask pageTask, ApprovalCheck approvalCheck) {
        this.addActivity(activity);
        this.pageState = pageState;
        this.pageTask = pageTask;
        this.approvalCheck = approvalCheck;
    }

    public static ActivityEntry create(Activity activity) {
        return new ActivityEntry(activity);
    }

    public static ActivityEntry create(Approver approver, PageState state, ApprovalCheck approvalCheck) {
        return new ActivityEntry((Activity)new ApprovalActivity(approvalCheck, approver), state, approvalCheck);
    }

    public static ActivityEntry create(Activity activity, PageState pageState, boolean currentState) {
        ActivityEntry activityEntry = new ActivityEntry(activity, pageState);
        if (activity instanceof PageTask) {
            activityEntry.setPageTask((PageTask)activity);
        }
        activityEntry.currentState = currentState;
        return activityEntry;
    }

    public static ActivityEntry create(Activity activity, PageState pageState) {
        return new ActivityEntry(activity, pageState);
    }

    public static ActivityEntry create(Activity activity, PageState pageState, ApprovalCheck approvalCheck) {
        return new ActivityEntry(activity, pageState, approvalCheck);
    }

    public static ActivityEntry create(Activity activity, PageState pageState, PageTask pageTask) {
        return new ActivityEntry(activity, pageState, pageTask);
    }

    public static ActivityEntry create(Activity activity, PageState pageState, PageTask pageTask, ApprovalCheck approvalCheck) {
        return new ActivityEntry(activity, pageState, pageTask, approvalCheck);
    }

    public static ActivityEntry create(Comment comment) {
        return new ActivityEntry(new CommentActivity(comment));
    }

    public static ActivityEntry create(VersionHistorySummary summary, List<ConfluenceUser> contributors) {
        return new ActivityEntry(new ModificationActivity(summary, contributors));
    }

    public static ActivityEntry create(ReadAckActivityModel readAckActivity, String workflowsUsername) {
        return new ActivityEntry(new ReadAckActivity(readAckActivity.status, readAckActivity.timestamp, workflowsUsername, readAckActivity.version));
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
        if (this.from == null) {
            this.from = activity.getDate();
        } else {
            this.to = activity.getDate();
        }
    }

    public boolean isTaskPending() {
        if (!this.currentState || !(this.getActivity() instanceof PageTask)) {
            return false;
        }
        PageTask task = (PageTask)this.getActivity();
        return !task.isCompleted();
    }

    public String getCssClass() {
        Activity activity = this.getActivity();
        StringBuffer sb = new StringBuffer(activity.getCssClass());
        if ((activity instanceof PageTask || activity instanceof Assignment || activity instanceof TaskCompletion) && this.getPageTask() != null) {
            sb.append(' ').append((Object)this.getPageTask().getType());
        }
        if (activity instanceof PageTask && this.activities.size() > 1 && this.activities.get(1) instanceof Assignment) {
            sb.append(" assignment");
        }
        if (activity instanceof ApprovalActivity) {
            ApprovalActivity approvalActivity = (ApprovalActivity)activity;
            sb.append(" ");
            if (approvalActivity.getApprover().isApproved()) {
                sb.append("approved");
            } else {
                sb.append("rejected");
            }
        }
        return sb.toString();
    }

    public Assignment getAssignment() {
        if (this.activities.size() > 1 && this.activities.get(1) instanceof Assignment) {
            return (Assignment)this.activities.get(1);
        }
        return null;
    }

    public boolean isTaskCompleted() {
        return this.getActivity() instanceof PageTask && ((PageTask)this.getActivity()).isCompleted();
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public Activity getActivity() {
        return this.activities.get(0);
    }

    public PageState getPageState() {
        return this.pageState;
    }

    public void setPageState(PageState pageState) {
        this.pageState = pageState;
    }

    public PageTask getPageTask() {
        return this.pageTask;
    }

    public void setPageTask(PageTask pageTask) {
        this.pageTask = pageTask;
    }

    public Date getFromDate() {
        return this.from;
    }

    public Date getToDate() {
        if (this.to == null) {
            return null;
        }
        if (this.from.equals(this.to)) {
            return null;
        }
        return this.to;
    }

    public DateTime getFromDateStartOfDay(TimeZone timezone) {
        return this.getStartOfDayWithTimeZone(this.from, timezone);
    }

    public DateTime getToDateStartOfDay(TimeZone timezone) {
        return this.getStartOfDayWithTimeZone(this.to, timezone);
    }

    private DateTime getStartOfDayWithTimeZone(Date date, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        DateTime dateTime = new DateTime(date);
        if (timezone != null) {
            dateTime = dateTime.withZone(DateTimeZone.forTimeZone(timezone.getWrappedTimeZone()));
        }
        dateTime = dateTime.withTimeAtStartOfDay();
        return dateTime;
    }

    public List<String> getActivityUsers() {
        if (this.activityUsers != null) {
            return this.activityUsers;
        }
        HashSet<String> users = new HashSet<String>();
        for (Activity activity : this.activities) {
            users.add(activity.getPerformer());
        }
        this.activityUsers = new ArrayList<String>(users);
        return this.activityUsers;
    }

    public Set<ConfluenceUser> getActivityContributors() {
        HashSet<ConfluenceUser> multipleContributors = new HashSet<ConfluenceUser>();
        for (Activity activity : this.activities) {
            List<ConfluenceUser> contributors;
            if (!(activity instanceof ModificationActivity) || (contributors = ((ModificationActivity)activity).getContributors()) == null) continue;
            multipleContributors.addAll(contributors);
        }
        return multipleContributors;
    }

    public boolean isSimilar(ActivityEntry other, TimeZone timeZone) {
        if (this.pageState == null ? other.getPageState() != null : !this.pageState.equals(other.getPageState())) {
            return false;
        }
        if (!this.getFromDateStartOfDay(timeZone).equals(other.getFromDateStartOfDay(timeZone))) {
            return false;
        }
        if (this.getToDate() == null ? other.getToDate() != null : !this.getToDateStartOfDay(timeZone).equals(other.getToDateStartOfDay(timeZone))) {
            return false;
        }
        if (this.getActivity().getPerformer() == null ? other.getActivity().getPerformer() != null : !this.getActivity().getPerformer().equals(other.getActivity().getPerformer())) {
            return false;
        }
        return this.activities.size() == 1 || this.getActivity() instanceof PageTask;
    }

    @Override
    public int compareTo(ActivityEntry activityEntry) {
        int i = this.getActivity().compareTo(activityEntry.getActivity());
        if (i != 0) {
            return i;
        }
        if (this.getActivity() instanceof PageState) {
            if (activityEntry.getActivity() instanceof PageState) {
                return 0;
            }
            return -1;
        }
        if (this.getActivity() instanceof PageTask) {
            if (activityEntry.getActivity() instanceof PageState) {
                return 1;
            }
            if (activityEntry.getActivity() instanceof PageTask) {
                return 0;
            }
            return -1;
        }
        if (this.getActivity() instanceof Assignment) {
            if (activityEntry.getActivity() instanceof PageState || activityEntry.getActivity() instanceof PageTask) {
                return 1;
            }
            if (activityEntry.getActivity() instanceof Assignment) {
                return 0;
            }
            return -1;
        }
        if (activityEntry.getActivity() instanceof PageState || activityEntry.getActivity() instanceof PageTask || activityEntry.getActivity() instanceof Assignment) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "ActivityEntry{" + this.getActivity().getDate() + " " + this.getActivity().toString() + " " + (String)(this.pageState != null ? "state=" + this.pageState.getState() + ", " : "") + (String)(this.pageTask != null ? "task=" + this.pageTask.getName() + ", " : "") + (String)(this.activities.size() > 1 ? this.activities.size() + " entries " : "") + "}";
    }

    public ApprovalCheck getApprovalCheck() {
        return this.approvalCheck;
    }

    public void setApprovalCheck(ApprovalCheck approvalCheck) {
        this.approvalCheck = approvalCheck;
    }
}

