/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.mapper;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalUsersMapper {
    private static final Logger log = LoggerFactory.getLogger(ApprovalUsersMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final UserAccessor userAccessor;

    public ApprovalUsersMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public List<String> map(String json) {
        LinkedHashMap approvers = null;
        try {
            approvers = mapper.readValue(json, LinkedHashMap.class);
        }
        catch (Exception ex) {
            log.warn("Cannot extract approvers key list from JsonContent Property {} : {}", new Object[]{json, this, ex});
        }
        if (approvers == null) {
            return null;
        }
        List userKeyList = (List)approvers.get("userKeyList");
        return this.getUserNames(userKeyList, this.userAccessor);
    }

    private List<String> getUserNames(List<String> userKeyList, UserAccessor accessor) {
        ArrayList<String> result = new ArrayList<String>();
        if (userKeyList != null) {
            for (String key : userKeyList) {
                String userName = this.getUserDataFromKey(key, accessor);
                if (userName == null) continue;
                result.add(userName);
            }
        }
        return result;
    }

    private String getUserDataFromKey(String key, UserAccessor accessor) {
        ConfluenceUser userByKey = accessor.getUserByKey(new UserKey(key));
        if (userByKey == null) {
            log.warn("Could NOT resolve data for userKey {}", (Object)key);
            return null;
        }
        return userByKey.getName();
    }

    static {
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

