/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.stats;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.DefaultValuesParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.PageParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.SpaceParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.StringListParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.stats.StatsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.PageParameterValidator;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ParameterValidator;
import com.comalatech.confluence.workflowreports.manager.stats.DocumentStatsReportManager;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReport;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReportOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStatsReportMacro
extends NoBodyBaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(DocumentStatsReportMacro.class);
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private DocumentStatsReportManager documentStatsReportManager;
    protected Parameters options;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private GlobalSettingsManager globalSettingsManager;
    @ComponentImport
    private PermissionManager permissionManager;
    private static final String STATS_TEMPLATE = "/templates/reports/document-stats-report.vm";

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            return this.execute(parameters, (RenderContext)conversionContext.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new Parameters(parameters, renderContext);
        Map contextMap = MacroUtils.defaultVelocityContext();
        DocumentStatsReport documentStatsReport = this.documentStatsReportManager.createReport(this.options.getDocumentStatsReportOptions());
        contextMap.put("documentStatsReport", documentStatsReport);
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        AbstractPage abstractPage = (AbstractPage)((PageContext)renderContext).getEntity();
        contextMap.put("refreshDataUrl", this.getRefreshUrl(abstractPage));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        contextMap.put("isSpaceAdmin", Objects.nonNull(confluenceUser) && this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, (Object)abstractPage.getSpace()));
        return this.renderTemplate(contextMap, STATS_TEMPLATE);
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    private String getBaseUrl() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl();
    }

    private String getRefreshUrl(AbstractPage page) {
        return this.getBaseUrl() + "/spaces/viewReportDataPopulation.action?key=" + page.getSpaceKey();
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setDocumentStatsReportManager(DocumentStatsReportManager documentStatsReportManager) {
        this.documentStatsReportManager = documentStatsReportManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setGlobalSettingsManager(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected class Parameters
    extends MacroParameters {
        private final DocumentStatsReportOptions documentStatsReportOptions;

        public DocumentStatsReportOptions getDocumentStatsReportOptions() {
            return this.documentStatsReportOptions;
        }

        public Parameters(Map parameters, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            AbstractPage page = null;
            if (renderContext instanceof PageContext && this.getAbstractPage() != null) {
                page = this.getAbstractPage().getLatestVersion();
            }
            List<ReportParameter> reportParameters = StatsReportParameters.getFiltersFrom(parameters.entrySet());
            this.applyParameterMappers(reportParameters, page);
            this.applyParametersValidators(reportParameters);
            this.documentStatsReportOptions = new DocumentStatsReportOptions(reportParameters);
        }

        private void applyParameterMappers(List<ReportParameter> reportParameters, AbstractPage page) {
            ArrayList<ParameterMapper> mappers = new ArrayList<ParameterMapper>();
            mappers.add(new DefaultValuesParameterMapper());
            mappers.add(new SpaceParameterMapper(page));
            mappers.add(new PageParameterMapper(DocumentStatsReportMacro.this.pageManager, page));
            mappers.add(new StringListParameterMapper());
            for (ReportParameter param : reportParameters) {
                mappers.forEach(mapper -> mapper.map(param));
            }
        }

        private void applyParametersValidators(List<ReportParameter> reportParameters) throws MacroException {
            ArrayList<PageParameterValidator> validators = new ArrayList<PageParameterValidator>();
            validators.add(new PageParameterValidator(DocumentStatsReportMacro.this.workflowsFeatureManager.getPluginKey()));
            for (ReportParameter parameter : reportParameters) {
                for (ParameterValidator parameterValidator : validators) {
                    parameterValidator.validate(parameter);
                }
            }
        }
    }
}

