/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum TasksReportParameters {
    SPACE("space", "@self"),
    MAX_ITEMS_PER_PAGE("maxItems", "20"),
    COLUMNS_TO_SHOW("columns", "page,state,task,status,assigned by,assigned, assigned to, due date, actual time spent"),
    ASSIGNEE("assignee"),
    PARENT_PAGE("parent"),
    ANCESTOR_PAGE("ancestor"),
    LABEL("label"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    final String key;
    String defaultValue;

    private TasksReportParameters(String key) {
        this.key = key;
    }

    private TasksReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<TasksReportParameters> fromString(String text) {
        return Arrays.stream(TasksReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry<?, ?>> macroParameterSet) {
        ArrayList<ReportParameter> reportParameters = new ArrayList<ReportParameter>();
        for (Map.Entry<?, ?> macroParam : macroParameterSet) {
            TasksReportParameters filter = TasksReportParameters.fromString(macroParam.getKey().toString()).orElse(null);
            if (Objects.isNull((Object)filter)) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            reportParameters.add(new ReportParameter(filter.key, new StringReportParameterValue(value, filter.defaultValue)));
        }
        TasksReportParameters.addMandatoryParameters(reportParameters);
        return reportParameters;
    }

    private static void addMandatoryParameters(List<ReportParameter> reportParameterList) {
        TasksReportParameters.fillReportFilter(reportParameterList, SPACE.getKey(), SPACE.getDefaultValue());
        TasksReportParameters.fillReportFilter(reportParameterList, MAX_ITEMS_PER_PAGE.getKey(), MAX_ITEMS_PER_PAGE.getDefaultValue());
        TasksReportParameters.fillReportFilter(reportParameterList, COLUMNS_TO_SHOW.getKey(), COLUMNS_TO_SHOW.getDefaultValue());
        TasksReportParameters.fillReportFilter(reportParameterList, ASSIGNEE.getKey(), ASSIGNEE.getDefaultValue());
    }

    private static void fillReportFilter(List<ReportParameter> reportParameterList, String key, String defaultValue) {
        boolean existParameter = reportParameterList.stream().anyMatch(param -> param.getKey().equals(key));
        if (!existParameter) {
            reportParameterList.add(new ReportParameter(key, new StringReportParameterValue(null, defaultValue)));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

