/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflowreports.macro.BaseWorkflowReportMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.TasksMacroParameters;
import com.comalatech.confluence.workflowreports.manager.tasks.WorkflowTaskReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowTaskReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.confluence.workflowreports.model.WorkflowTasksReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowTasksReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowTasksReportOptionsCqlPresenter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowTaskReportMacro
extends BaseWorkflowReportMacro {
    private static final String TASKS_TEMPLATE = "/templates/reports/macros/tasks-report-macro.vm";
    private static final String EXPORT_TASK_TEMPLATE = "/templates/reports/macros/export-task-report-macro.vm";
    private static List<String> COLUMNSTOSHOW = Arrays.asList("title", "state", "task", "status", "assignedby", "assigned", "assignedto", "duedate", "timespent");
    protected TasksMacroParameters options;
    private WorkflowTaskReportManager workflowTaskReportManager;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new TasksMacroParameters(parameters, renderContext, this.workflowsFeatureManager, this.userAccessor, this.pageManager);
        WorkflowTasksReportOptions tasksReportOptions = this.options.getWorkflowReportOptions();
        WorkflowReportFilters reportFilters = this.buildReportFilters(this.options.getWorkflowReportOptions());
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowTasksReportOptionsCqlPresenter(tasksReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowTasksReportFiltersJsonPresenter(reportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        contextMap.put("isPreview", "preview".equals(renderContext.getOutputType()));
        if (Boolean.parseBoolean((String)renderContext.getParam((Object)"send-email"))) {
            renderContext.setOutputType("email");
        }
        switch (renderContext.getOutputType()) {
            case "preview": 
            case "display": {
                return this.renderTemplate(contextMap, TASKS_TEMPLATE);
            }
            case "word": 
            case "pdf": 
            case "html_export": 
            case "email": {
                return this.renderExportTaskReportTemplate(tasksReportOptions, contextMap);
            }
        }
        return null;
    }

    private String renderExportTaskReportTemplate(WorkflowTasksReportOptions options, Map<String, Object> contextMap) throws MacroException {
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        List<ExportWorkflowTaskReportEntry> reportEntries = this.workflowTaskReportManager.createReport(options, contextMap);
        renderMap.put("exportReport", reportEntries);
        renderMap.put("columnsToShow", COLUMNSTOSHOW);
        return this.renderTemplate(renderMap, EXPORT_TASK_TEMPLATE);
    }

    public void setWorkflowTaskReportManager(WorkflowTaskReportManager workflowTaskReportManager) {
        this.workflowTaskReportManager = workflowTaskReportManager;
    }
}

