/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportFilterWorkflow;
import com.comalatech.confluence.workflowreports.macro.BaseWorkflowReportMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.ActionsMacroParameters;
import com.comalatech.confluence.workflowreports.manager.actions.WorkflowActionsReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowActionsReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowActionsReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowActionsReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowActionsReportOptionsCqlPresenter;
import com.comalatech.workflow.model.Workflow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowActionsReportMacro
extends BaseWorkflowReportMacro {
    private static final String ACTIONS_TEMPLATE = "/templates/reports/macros/actions-report-macro.vm";
    private static final String EXPORT_ACTIONS_TEMPLATE = "/templates/reports/macros/export-actions-report-macro.vm";
    private static List<String> COLUMNSTOSHOW = Arrays.asList("action", "assignedby", "assignmentdate", "duedate", "appearson");
    protected ActionsMacroParameters options;
    private WorkflowActionsReportManager workflowActionsReportManager;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new ActionsMacroParameters(parameters, renderContext, this.workflowsFeatureManager, this.userAccessor, this.pageManager);
        WorkflowActionsReportOptions actionsReportOptions = this.options.getWorkflowActionsReportOptions();
        WorkflowReportFilters actionsReportFilters = this.buildReportFilters();
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowActionsReportOptionsCqlPresenter(actionsReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowActionsReportFiltersJsonPresenter(actionsReportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        if (Boolean.parseBoolean((String)renderContext.getParam((Object)"send-email"))) {
            renderContext.setOutputType("email");
        }
        switch (renderContext.getOutputType()) {
            case "preview": 
            case "display": {
                return this.renderTemplate(contextMap, ACTIONS_TEMPLATE);
            }
            case "word": 
            case "pdf": 
            case "html_export": 
            case "email": {
                return this.renderExportActionsReportTemplate(actionsReportOptions, contextMap);
            }
        }
        return null;
    }

    private WorkflowReportFilters buildReportFilters() {
        List<String> states = this.getReportStatesFilter();
        List<RestSpaceReportFilterWorkflow> workflows = this.getReportWorkflowFilter();
        return new WorkflowReportFilters(states, workflows);
    }

    protected List<String> getReportStatesFilter() {
        ArrayList<String> spaceStates = new ArrayList<String>();
        if (this.options.getWorkflowActionsReportOptions().isSingleSpace()) {
            spaceStates.addAll(this.workflowSearchService.getSpaceStates(this.options.getWorkflowActionsReportOptions().getFirstSpaceKey()));
        }
        return spaceStates;
    }

    protected List<RestSpaceReportFilterWorkflow> getReportWorkflowFilter() {
        ArrayList<RestSpaceReportFilterWorkflow> restWorkflows = new ArrayList<RestSpaceReportFilterWorkflow>();
        if (this.workflowsFeatureManager.isWorkflowsApp() || this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            if (this.options.getWorkflowActionsReportOptions().isSingleSpace()) {
                workflows.addAll(this.workflowService.getWorkflows(this.options.getWorkflowActionsReportOptions().getFirstSpaceKey()));
            }
            for (Workflow workflow : workflows) {
                if (!workflow.isActive()) continue;
                RestSpaceReportFilterWorkflow restWorkflow = new RestSpaceReportFilterWorkflow();
                restWorkflow.name = workflow.getName();
                restWorkflow.states = workflow.getStateNames();
                restWorkflows.add(restWorkflow);
            }
        }
        return restWorkflows;
    }

    private String renderExportActionsReportTemplate(WorkflowActionsReportOptions options, Map<String, Object> contextMap) throws MacroException {
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        List<ExportWorkflowActionsReportEntry> reportEntries = this.workflowActionsReportManager.createReport(options, contextMap);
        renderMap.put("exportReport", reportEntries);
        renderMap.put("columnsToShow", COLUMNSTOSHOW);
        return this.renderTemplate(renderMap, EXPORT_ACTIONS_TEMPLATE);
    }

    public void setWorkflowActionsReportManager(WorkflowActionsReportManager workflowActionsReportManager) {
        this.workflowActionsReportManager = workflowActionsReportManager;
    }
}

